/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter.sessions;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ru.qatools.gridrouter.sessions.BrowserVersion;
import ru.qatools.gridrouter.sessions.GridRouterUserStats;

public class BrowsersCountMap
extends HashMap<String, Map<String, Integer>>
implements GridRouterUserStats {
    public void increment(String browser, String version) {
        this.putIfAbsent(browser, new HashMap());
        ((Map)this.get(browser)).compute(version, (v, count) -> Optional.ofNullable(count).orElse(0) + 1);
    }

    public void decrement(BrowserVersion browser) {
        this.decrement(browser.getBrowser(), browser.getVersion());
    }

    public void decrement(String browser, String version) {
        if (!this.containsKey(browser)) {
            return;
        }
        Map versions = (Map)this.get(browser);
        if (!versions.containsKey(version)) {
            return;
        }
        int count = (Integer)versions.get(version) - 1;
        if (count > 0) {
            versions.put(version, count);
        } else {
            versions.remove(version);
        }
        if (versions.isEmpty()) {
            this.remove(browser);
        }
    }
}

