/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import ru.qatools.gridrouter.SpringHttpServlet;
import ru.qatools.gridrouter.json.JsonFormatter;
import ru.qatools.gridrouter.sessions.StatsCounter;

@WebServlet(urlPatterns={"/stats"}, asyncSupported=true)
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user"}))
public class StatsServlet
extends SpringHttpServlet {
    @Autowired
    private transient StatsCounter statsCounter;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
        response.setContentType("application/json");
        try (ServletOutputStream output = response.getOutputStream();){
            IOUtils.write((String)JsonFormatter.toJson(this.statsCounter.getStats(request.getRemoteUser())), (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
    }
}

