/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.util.item;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.divinecraft.customstuff.api.nbt.NBTItem;
import ru.divinecraft.customstuff.api.util.item.ItemStackBuilder;

public class SimpleItemStackBuilder<M extends ItemMeta>
implements ItemStackBuilder<M> {
    @NonNull
    protected final ItemFactory itemFactory;
    @NonNull
    protected Material type;
    protected int amount = 1;
    protected short damage;
    @Nullable
    protected M meta;

    protected SimpleItemStackBuilder(@NonNull ItemFactory itemFactory) {
        if (itemFactory == null) {
            throw new NullPointerException("itemFactory is marked non-null but is null");
        }
        this.itemFactory = itemFactory;
    }

    public static <M extends ItemMeta> ItemStackBuilder<M> create(@NonNull ItemFactory itemFactory) {
        if (itemFactory == null) {
            throw new NullPointerException("itemFactory is marked non-null but is null");
        }
        return new SimpleItemStackBuilder<M>(itemFactory);
    }

    public static <M extends ItemMeta> ItemStackBuilder<M> create(@NonNull Server server) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        return SimpleItemStackBuilder.create(server.getItemFactory());
    }

    protected M nonNullMeta() {
        M thisMeta = this.meta;
        if (thisMeta == null) {
            Material thisType = this.type;
            this.meta = thisType == null ? this.itemFactory.getItemMeta(Material.STONE) : this.itemFactory.getItemMeta(thisType);
            return this.meta;
        }
        return thisMeta;
    }

    @Override
    @NotNull
    public ItemStackBuilder<M> name(@Nullable String name) {
        this.nonNullMeta().setDisplayName(name);
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder<M> unbreakable(boolean unbreakable) {
        this.nonNullMeta().setUnbreakable(unbreakable);
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder<M> lore(@NonNull List<@NotNull String> lore) {
        if (lore == null) {
            throw new NullPointerException("lore is marked non-null but is null");
        }
        this.nonNullMeta().setLore(lore);
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder<M> modifyMeta(@NonNull Consumer<@NotNull M> metadataModifier) {
        if (metadataModifier == null) {
            throw new NullPointerException("metadataModifier is marked non-null but is null");
        }
        metadataModifier.accept(this.nonNullMeta());
        return this;
    }

    @Override
    @NotNull
    public <MNew extends ItemMeta> ItemStackBuilder<MNew> meta(@NonNull MNew meta) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        SimpleItemStackBuilder self = this;
        this.meta = meta;
        return self;
    }

    @Override
    @NotNull
    public ItemStack build() {
        Material thisType = this.type;
        Preconditions.checkState((thisType != null ? 1 : 0) != 0, (Object)"Type is unset");
        ItemStack item = new ItemStack(thisType, this.amount, this.damage);
        M thisMeta = this.meta;
        if (thisMeta != null) {
            item.setItemMeta(thisMeta);
        }
        return item;
    }

    @Override
    @NotNull
    public ItemStack build(@NonNull Consumer<NBTItem> nbtModifier) {
        if (nbtModifier == null) {
            throw new NullPointerException("nbtModifier is marked non-null but is null");
        }
        NBTItem nbtItem = new NBTItem(this.build());
        nbtModifier.accept(nbtItem);
        return nbtItem.getItem();
    }

    @Override
    public SimpleItemStackBuilder<M> type(@NonNull Material type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        return this;
    }

    @Override
    public SimpleItemStackBuilder<M> amount(int amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public SimpleItemStackBuilder<M> damage(short damage) {
        this.damage = damage;
        return this;
    }
}

