/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.recipe;

import com.google.common.base.Preconditions;
import java.util.List;
import lombok.NonNull;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import ru.divinecraft.customstuff.api.recipe.CustomShapelessRecipe;
import ru.divinecraft.customstuff.api.recipe.ItemStackMatcher;

public final class StaticCustomShapelessRecipe
implements CustomShapelessRecipe {
    @NotNull
    private final ItemStack result;
    private final @Unmodifiable @NotNull List<@Nullable ItemStackMatcher> componentMatchers;

    @NotNull
    public static CustomShapelessRecipe create(@NonNull ItemStack result, @NonNull @NonNull @Unmodifiable List<@NonNull ItemStackMatcher> componentMatchers) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        if (componentMatchers == null) {
            throw new NullPointerException("componentMatchers is marked non-null but is null");
        }
        for (ItemStackMatcher componentMatcher : componentMatchers) {
            Preconditions.checkNotNull((Object)componentMatcher, (Object)"componentMatchers cannot contain null values");
        }
        return new StaticCustomShapelessRecipe(result, componentMatchers);
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public @NotNull List<@Nullable ItemStackMatcher> getComponentMatchers() {
        return this.componentMatchers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StaticCustomShapelessRecipe)) {
            return false;
        }
        StaticCustomShapelessRecipe other = (StaticCustomShapelessRecipe)o;
        ItemStack this$result = this.getResult();
        ItemStack other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        List<ItemStackMatcher> this$componentMatchers = this.getComponentMatchers();
        List<ItemStackMatcher> other$componentMatchers = other.getComponentMatchers();
        return !(this$componentMatchers == null ? other$componentMatchers != null : !((Object)this$componentMatchers).equals(other$componentMatchers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemStack $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        List<ItemStackMatcher> $componentMatchers = this.getComponentMatchers();
        result = result * 59 + ($componentMatchers == null ? 43 : ((Object)$componentMatchers).hashCode());
        return result;
    }

    public String toString() {
        return "StaticCustomShapelessRecipe(result=" + this.getResult() + ", componentMatchers=" + this.getComponentMatchers() + ")";
    }

    private StaticCustomShapelessRecipe(@NotNull ItemStack result, @NotNull List<@Nullable ItemStackMatcher> componentMatchers) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        if (componentMatchers == null) {
            throw new NullPointerException("componentMatchers is marked non-null but is null");
        }
        this.result = result;
        this.componentMatchers = componentMatchers;
    }
}

