/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.nbt.utils.nmsmappings;

import java.util.logging.Level;
import org.bukkit.Bukkit;
import ru.divinecraft.customstuff.api.nbt.utils.MinecraftVersion;
import ru.divinecraft.customstuff.api.nbt.utils.nmsmappings.PackageWrapper;

public enum ClassWrapper {
    CRAFT_ITEMSTACK(PackageWrapper.CRAFTBUKKIT, "inventory.CraftItemStack"),
    CRAFT_METAITEM(PackageWrapper.CRAFTBUKKIT, "inventory.CraftMetaItem"),
    CRAFT_ENTITY(PackageWrapper.CRAFTBUKKIT, "entity.CraftEntity"),
    CRAFT_WORLD(PackageWrapper.CRAFTBUKKIT, "CraftWorld"),
    NMS_NBTBASE(PackageWrapper.NMS, "NBTBase"),
    NMS_NBTTAGSTRING(PackageWrapper.NMS, "NBTTagString"),
    NMS_NBTTAGINT(PackageWrapper.NMS, "NBTTagInt"),
    NMS_NBTTAGFLOAT(PackageWrapper.NMS, "NBTTagFloat"),
    NMS_NBTTAGDOUBLE(PackageWrapper.NMS, "NBTTagDouble"),
    NMS_NBTTAGLONG(PackageWrapper.NMS, "NBTTagLong"),
    NMS_ITEMSTACK(PackageWrapper.NMS, "ItemStack"),
    NMS_NBTTAGCOMPOUND(PackageWrapper.NMS, "NBTTagCompound"),
    NMS_NBTTAGLIST(PackageWrapper.NMS, "NBTTagList"),
    NMS_NBTCOMPRESSEDSTREAMTOOLS(PackageWrapper.NMS, "NBTCompressedStreamTools"),
    NMS_MOJANGSONPARSER(PackageWrapper.NMS, "MojangsonParser"),
    NMS_TILEENTITY(PackageWrapper.NMS, "TileEntity"),
    NMS_BLOCKPOSITION(PackageWrapper.NMS, "BlockPosition", MinecraftVersion.MC1_8_R3, null),
    NMS_WORLDSERVER(PackageWrapper.NMS, "WorldServer"),
    NMS_MINECRAFTSERVER(PackageWrapper.NMS, "MinecraftServer"),
    NMS_WORLD(PackageWrapper.NMS, "World"),
    NMS_ENTITY(PackageWrapper.NMS, "Entity"),
    NMS_ENTITYTYPES(PackageWrapper.NMS, "EntityTypes"),
    NMS_REGISTRYSIMPLE(PackageWrapper.NMS, "RegistrySimple", MinecraftVersion.MC1_11_R1, MinecraftVersion.MC1_12_R1),
    NMS_REGISTRYMATERIALS(PackageWrapper.NMS, "RegistryMaterials"),
    NMS_IREGISTRY(PackageWrapper.NMS, "IRegistry"),
    NMS_MINECRAFTKEY(PackageWrapper.NMS, "MinecraftKey", MinecraftVersion.MC1_8_R3, null),
    NMS_GAMEPROFILESERIALIZER(PackageWrapper.NMS, "GameProfileSerializer"),
    NMS_IBLOCKDATA(PackageWrapper.NMS, "IBlockData", MinecraftVersion.MC1_8_R3, null),
    GAMEPROFILE("com.mojang.authlib.GameProfile", MinecraftVersion.MC1_8_R3);

    private Class<?> clazz;
    private boolean enabled = false;

    private ClassWrapper(PackageWrapper packageId, String suffix) {
        this(packageId, suffix, null, null);
    }

    private ClassWrapper(PackageWrapper packageId, String suffix, MinecraftVersion from, MinecraftVersion to) {
        if (from != null && MinecraftVersion.getVersion().getVersionId() < from.getVersionId()) {
            return;
        }
        if (to != null && MinecraftVersion.getVersion().getVersionId() > to.getVersionId()) {
            return;
        }
        this.enabled = true;
        try {
            String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            this.clazz = Class.forName(packageId.getUri() + "." + version + "." + suffix);
        }
        catch (Exception ex) {
            MinecraftVersion.getLogger().log(Level.WARNING, "[NBTAPI] Error while trying to resolve the class '" + suffix + "'!", ex);
        }
    }

    private ClassWrapper(String path, MinecraftVersion from) {
        if (from != null && MinecraftVersion.getVersion().getVersionId() < from.getVersionId()) {
            return;
        }
        this.enabled = true;
        try {
            this.clazz = Class.forName(path);
        }
        catch (Exception ex) {
            MinecraftVersion.getLogger().log(Level.WARNING, "[NBTAPI] Error while trying to resolve the class '" + path + "'!", ex);
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

