/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.item.manager;

import com.flowpowered.nbt.CompoundMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import ru.divinecraft.customstuff.api.item.CustomItem;

public interface CustomItemManager {
    @Contract(pure=true)
    @NotNull
    public @Unmodifiable Map<String, ItemFactory> getItemFactories();

    @Contract(pure=true)
    @Nullable
    public ItemFactory getItemFactory(@NotNull String var1);

    @Contract(pure=true)
    public boolean hasItemFactory(String var1);

    @Nullable
    public CustomItem createNewCustomItem(@NotNull String var1, @Nullable CompoundMap var2);

    public boolean isCustomItem(@Nullable ItemStack var1);

    @Nullable
    public CustomItem asCustomItem(@Nullable ItemStack var1);

    @NotNull
    public Item dropItem(@NotNull Location var1, @NotNull String var2, @Nullable CompoundMap var3);

    @NotNull
    public Item dropItemNaturally(@NotNull Location var1, @NotNull String var2, @Nullable CompoundMap var3);

    @FunctionalInterface
    public static interface ItemFactory
    extends ItemCreator {
        public static final @Unmodifiable @NotNull Set<@Nullable CompoundMap> ONLY_NULL_VARIANT = Collections.singleton(null);

        default public @NotNull Enumeration<@Nullable CompoundMap> defaultVariants() {
            return Collections.enumeration(ONLY_NULL_VARIANT);
        }

        @Contract(value="_, _ -> new")
        @NotNull
        public static ItemFactory create(final ItemCreator creator, CompoundMap ... defaultVariants) {
            if (defaultVariants == null) {
                throw new NullPointerException("defaultVariants is marked non-null but is null");
            }
            final Enumeration<CompoundMap> defaultVariantsEnumeration = Collections.enumeration(Arrays.asList(defaultVariants));
            return new ItemFactory(){

                @Override
                @NotNull
                public CustomItem create(@NotNull CustomItemManager manager, @Nullable CompoundMap nbtTags) {
                    return creator.create(manager, nbtTags);
                }

                @Override
                public @NotNull Enumeration<@Nullable CompoundMap> defaultVariants() {
                    return defaultVariantsEnumeration;
                }
            };
        }

        @Contract(value="_ -> new")
        @NotNull
        default public ItemFactory withVariants(CompoundMap ... defaultVariants) {
            if (defaultVariants == null) {
                throw new NullPointerException("defaultVariants is marked non-null but is null");
            }
            return ItemFactory.create(this, defaultVariants);
        }
    }

    @FunctionalInterface
    public static interface ItemCreator {
        @NotNull
        public CustomItem create(@NotNull CustomItemManager var1, @Nullable CompoundMap var2);
    }
}

