/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.item;

import java.util.Enumeration;
import lombok.NonNull;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ru.divinecraft.customstuff.api.item.StaticCustomItem;
import ru.divinecraft.customstuff.api.item.manager.CustomItemManager;
import ru.divinecraft.customstuff.api.item.manager.LoadingCustomItemManager;
import ru.divinecraft.customstuff.api.item.properties.ItemProperties;
import ru.divinecraft.customstuff.api.service.CustomStuff;
import ru.divinecraft.customstuff.api.service.CustomStuffDependantService;
import ru.divinecraft.customstuff.api.service.LoadingCustomStuff;

public interface CustomItems
extends CustomStuffDependantService {
    @NotNull
    public @NotNull Enumeration<@NotNull CustomItemRegistration> registrations();

    public static void register(@NonNull CustomItems customItems, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull PendingService.OwnedService<@NotNull LoadingCustomStuff.PreLoaders, @NotNull CustomStuff> loadingCustomStuff) {
        if (customItems == null) {
            throw new NullPointerException("customItems is marked non-null but is null");
        }
        if (loadingCustomStuff == null) {
            throw new NullPointerException("loadingCustomStuff is marked non-null but is null");
        }
        Enumeration<CustomItemRegistration> registrations = customItems.registrations();
        LoadingCustomItemManager manager = ((LoadingCustomStuff.PreLoaders)loadingCustomStuff.service()).itemManager();
        while (registrations.hasMoreElements()) {
            CustomItemRegistration registration = registrations.nextElement();
            manager.registerCustomItem(registration.name(), registration.itemFactory());
        }
        loadingCustomStuff.onceReady(customItems::setup);
    }

    @NotNull
    public static CustomItemRegistration blockItemRegistration(@NotNull String typeName, @NotNull ItemProperties properties, @NotNull ItemStack bukkitItem) {
        return SimpleCustomItemRegistration.of(typeName, (manager, nbt) -> StaticCustomItem.create(typeName, properties, manager, bukkitItem, typeName, nbt));
    }

    public static final class SimpleCustomItemRegistration
    implements CustomItemRegistration {
        @NonNull
        private final String name;
        @NonNull
        private final CustomItemManager.ItemFactory itemFactory;

        @NotNull
        public static CustomItemRegistration of(@NonNull String name, @NonNull CustomItemManager.ItemFactory itemFactory) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (itemFactory == null) {
                throw new NullPointerException("itemFactory is marked non-null but is null");
            }
            return new SimpleCustomItemRegistration(name, itemFactory);
        }

        @Override
        @NonNull
        public String name() {
            return this.name;
        }

        @Override
        @NonNull
        public CustomItemManager.ItemFactory itemFactory() {
            return this.itemFactory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleCustomItemRegistration)) {
                return false;
            }
            SimpleCustomItemRegistration other = (SimpleCustomItemRegistration)o;
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            CustomItemManager.ItemFactory this$itemFactory = this.itemFactory();
            CustomItemManager.ItemFactory other$itemFactory = other.itemFactory();
            return !(this$itemFactory == null ? other$itemFactory != null : !this$itemFactory.equals(other$itemFactory));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            CustomItemManager.ItemFactory $itemFactory = this.itemFactory();
            result = result * 59 + ($itemFactory == null ? 43 : $itemFactory.hashCode());
            return result;
        }

        public String toString() {
            return "CustomItems.SimpleCustomItemRegistration(name=" + this.name() + ", itemFactory=" + this.itemFactory() + ")";
        }

        private SimpleCustomItemRegistration(@NonNull String name, @NonNull CustomItemManager.ItemFactory itemFactory) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (itemFactory == null) {
                throw new NullPointerException("itemFactory is marked non-null but is null");
            }
            this.name = name;
            this.itemFactory = itemFactory;
        }
    }

    public static interface CustomItemRegistration {
        @NotNull
        public String name();

        @NotNull
        public CustomItemManager.ItemFactory itemFactory();
    }
}

