/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.item;

import com.flowpowered.nbt.CompoundMap;
import com.flowpowered.nbt.StringTag;
import com.flowpowered.nbt.Tag;
import com.flowpowered.nbt.TagType;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import lombok.NonNull;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import ru.divinecraft.customstuff.api.item.properties.ItemProperties;
import ru.divinecraft.customstuff.api.item.properties.StaticItemProperties;
import ru.divinecraft.customstuff.api.nbt.NBTCompound;
import ru.divinecraft.customstuff.api.nbt.NBTItem;
import ru.divinecraft.customstuff.api.recipe.ItemStackMatcher;

public interface CustomItem {
    @NotNull
    public static final String CUSTOM_ITEM_TAG_NAME = "custom_item";
    @NotNull
    public static final String TYPE_TAG_NAME = "type";

    @Contract(pure=true)
    @NotNull
    public String getTypeName();

    @Contract(pure=true)
    @NotNull
    default public ItemProperties getProperties() {
        return StaticItemProperties.stackable();
    }

    @Contract(pure=true)
    @Nullable
    public String getBlockTypeName();

    @Nullable
    public CompoundMap getBlockNbtTags();

    @NotNull
    public ItemStack asItemStack();

    default public boolean onClick(@NotNull Player player, @NotNull Action action, @NotNull BlockFace blockFace, boolean mainHand, @NotNull Block block) {
        return false;
    }

    @NotNull
    public static Tag<?> typeNameTag(@NotNull String typeName) {
        return new StringTag(TYPE_TAG_NAME, typeName);
    }

    public static void writeType(@NotNull CompoundMap tags, @NotNull String typeName) {
        tags.put(CustomItem.typeNameTag(typeName));
    }

    @Nullable
    public static String readType(@NotNull CompoundMap tags) {
        Tag tag = tags.get((Object)TYPE_TAG_NAME);
        if (tag != null && tag.getType() == TagType.TAG_STRING) {
            return ((StringTag)tag).getValue();
        }
        return null;
    }

    @Nullable
    public static String readType(@NotNull NBTCompound tags) {
        return tags.getString(TYPE_TAG_NAME);
    }

    @Nullable
    public static String readType(@NotNull NBTItem item) {
        NBTCompound tags = item.getCompound(CUSTOM_ITEM_TAG_NAME);
        return tags == null ? null : CustomItem.readType(tags);
    }

    public static void writeType(@NotNull NBTCompound tags, @NotNull String type) {
        tags.setString(TYPE_TAG_NAME, type);
    }

    public static void writeType(@NotNull NBTItem tags, @NotNull String type) {
        CustomItem.writeType(tags.addCompound(CUSTOM_ITEM_TAG_NAME), type);
    }

    @NotNull
    public static ItemStackMatcher matcherForType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return item -> {
            String actualType = CustomItem.readType(new NBTItem(item));
            return actualType != null && actualType.equals(type);
        };
    }

    @NotNull
    public static ItemStackMatcher matcherForType(final @NonNull String type, final @Unmodifiable @Nullable Set<@Unmodifiable @NonNull ItemStack> icons) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (icons != null) {
            for (ItemStack icon : icons) {
                Preconditions.checkNotNull((Object)icon, (Object)"None of the items can be null");
            }
        }
        return new ItemStackMatcher(){

            @Override
            public boolean matches(@NotNull ItemStack item) {
                String actualType = CustomItem.readType(new NBTItem(item));
                return actualType != null && actualType.equals(type);
            }

            @Override
            public @Unmodifiable @Nullable Set<ItemStack> icons() {
                return icons;
            }
        };
    }

    @NotNull
    public static ItemStackMatcher matcherForType(@NonNull String type, @Nullable ItemStack icon) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return CustomItem.matcherForType(type, icon == null ? null : Collections.singleton(icon));
    }
}

