/*
 * Decompiled with CFR 0.152.
 */
package ru.divinecraft.customstuff.api.chunk;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import lombok.NonNull;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.divinecraft.customstuff.api.chunk.ChunkDataStorage;
import ru.progrm_jarvis.javacommons.pair.Pair;
import ru.progrm_jarvis.javacommons.pair.SimplePair;

public class ArrayBasedChunkDataStorage<@NotNull T>
implements ChunkDataStorage<T> {
    public static final int LAYERS_COUNT = 256;
    public static final int LAYER_SIZE = 256;
    @NonNull
    protected LayerAllocator<T> allocator;
    protected int size;
    @Nullable
    protected @Nullable T @Nullable [] @Nullable [] layers;
    protected byte occupiedLayers;
    protected byte @Nullable [] layerSizes;

    protected static int indexY(byte y) {
        return y & 0xFF;
    }

    protected static int indexXZ(byte x, byte z) {
        return (x & 0xF) << 4 | z & 0xF;
    }

    protected static int xFromIndexXZ(int indexXZ) {
        return indexXZ >> 4;
    }

    protected static int zFromIndexXZ(int indexXZ) {
        return indexXZ & 0xF;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public T get(byte x, byte y, byte z) {
        T[][] layers = this.layers;
        if (this.layers == null) {
            return null;
        }
        T[] layer = layers[ArrayBasedChunkDataStorage.indexY(y)];
        return layer == null ? null : (T)layer[ArrayBasedChunkDataStorage.indexXZ(x, z)];
    }

    @Override
    public void set(byte x, byte y, byte z, @Nullable T value) {
        T[][] layers = this.layers;
        if (this.layers == null) {
            if (value == null) {
                return;
            }
            T[][] TArray = this.allocator.allocateLayers();
            this.layers = TArray;
            int indexY = ArrayBasedChunkDataStorage.indexY(y);
            T[] TArray2 = this.allocator.allocateLayer();
            TArray[indexY] = TArray2;
            TArray2[ArrayBasedChunkDataStorage.indexXZ((byte)x, (byte)z)] = value;
            byte[] byArray = new byte[256];
            this.layerSizes = byArray;
            byArray[indexY] = 1;
            this.occupiedLayers = 1;
            this.size = 1;
            return;
        }
        int indexY = ArrayBasedChunkDataStorage.indexY(y);
        T[] layer = layers[indexY];
        if (layer == null) {
            if (value == null) {
                return;
            }
            T[] TArray = this.allocator.allocateLayer();
            layers[indexY] = TArray;
            TArray[ArrayBasedChunkDataStorage.indexXZ((byte)x, (byte)z)] = value;
            this.layerSizes[indexY] = 1;
            this.occupiedLayers = (byte)(this.occupiedLayers + 1);
            ++this.size;
            return;
        }
        int indexXZ = ArrayBasedChunkDataStorage.indexXZ(x, z);
        if (value == null) {
            if (layer[indexXZ] != null) {
                int n = indexY;
                this.layerSizes[n] = (byte)(this.layerSizes[n] - 1);
                if (this.layerSizes[n] == 0) {
                    this.occupiedLayers = (byte)(this.occupiedLayers - 1);
                    if (this.occupiedLayers == 0) {
                        this.layers = null;
                    } else {
                        layers[indexY] = null;
                    }
                }
                --this.size;
            }
        } else {
            if (layer[indexXZ] == null) {
                int n = indexY;
                this.layerSizes[n] = (byte)(this.layerSizes[n] + 1);
                ++this.size;
            }
            layer[indexXZ] = value;
        }
    }

    @Override
    @Nullable
    public T remove(byte x, byte y, byte z) {
        T[][] layers = this.layers;
        if (this.layers == null) {
            return null;
        }
        int indexY = ArrayBasedChunkDataStorage.indexY(y);
        T[] layer = layers[indexY];
        if (layer == null) {
            return null;
        }
        int indexXZ = ArrayBasedChunkDataStorage.indexXZ(x, z);
        T oldValue = layer[indexXZ];
        if (oldValue != null) {
            int n = indexY;
            this.layerSizes[n] = (byte)(this.layerSizes[n] - 1);
            if (this.layerSizes[n] == 0) {
                this.occupiedLayers = (byte)(this.occupiedLayers - 1);
                if (this.occupiedLayers == 0) {
                    this.layers = null;
                } else {
                    layers[indexY] = null;
                }
            } else {
                layer[indexXZ] = null;
            }
            --this.size;
        }
        return oldValue;
    }

    public static <T> ChunkDataStorage<T> withAllocator(@NonNull LayerAllocator<T> allocator) {
        if (allocator == null) {
            throw new NullPointerException("allocator is marked non-null but is null");
        }
        return new ArrayBasedChunkDataStorage<T>(allocator);
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull Pair<@NotNull Vector, @NotNull T>> iterator() {
        return new NonCheckingIterator();
    }

    @Override
    public Spliterator<@NotNull Pair<@NotNull Vector, @NotNull T>> spliterator() {
        return Spliterators.spliterator(new NonCheckingIterator(), (long)this.size, 321);
    }

    public ArrayBasedChunkDataStorage(@NonNull LayerAllocator<T> allocator) {
        if (allocator == null) {
            throw new NullPointerException("allocator is marked non-null but is null");
        }
        this.allocator = allocator;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected class NonCheckingIterator
    implements Iterator<Pair<Vector, T>> {
        protected @Nullable Pair<@NotNull Vector, @NotNull T> next;
        protected int lastLayerY = -1;
        protected int xz = 0;
        protected int leftOnCurrentLayer = 0;
        protected T[] layer;
        protected boolean canRemove = false;

        protected NonCheckingIterator() {
            this.computeNext();
        }

        protected void computeNext() {
            int xz;
            int leftOnCurrentLayer;
            if (ArrayBasedChunkDataStorage.this.layers == null) {
                return;
            }
            int y = this.lastLayerY;
            T[] layer = this.layer;
            if (this.layer == null) {
                byte[] layerSizes = ArrayBasedChunkDataStorage.this.layerSizes;
                assert (layerSizes != null);
                do {
                    if (++y != 256) continue;
                    this.next = null;
                    return;
                } while ((leftOnCurrentLayer = 0xFF & layerSizes[y]) == 0);
                this.lastLayerY = y;
                this.layer = layer = ArrayBasedChunkDataStorage.this.layers[this.lastLayerY];
                assert (layer != null);
                xz = 0;
            } else {
                leftOnCurrentLayer = this.leftOnCurrentLayer;
                xz = this.xz;
            }
            while (xz < 256) {
                Object value = layer[xz];
                if (value != null) {
                    this.next = SimplePair.of((Object)new Vector(ArrayBasedChunkDataStorage.xFromIndexXZ(xz), y, ArrayBasedChunkDataStorage.zFromIndexXZ(xz)), value);
                    if ((this.leftOnCurrentLayer = --leftOnCurrentLayer) == 0) {
                        this.layer = null;
                    } else {
                        this.xz = xz + 1;
                    }
                    return;
                }
                ++xz;
            }
            throw new ConcurrentModificationException("Iterated ChunkDataStorage might have been modified while being iterated");
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        @NotNull
        public @NotNull Pair<@NotNull Vector, @NotNull T> next() {
            Pair<@NotNull Vector, @NotNull T> next = this.next;
            if (next == null) {
                throw new NoSuchElementException("There are no more elements");
            }
            this.computeNext();
            this.canRemove = true;
            return next;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            int previousXz = this.xz - 1;
            ArrayBasedChunkDataStorage.this.remove((byte)ArrayBasedChunkDataStorage.xFromIndexXZ(previousXz), (byte)this.lastLayerY, (byte)ArrayBasedChunkDataStorage.zFromIndexXZ(previousXz));
            this.canRemove = false;
        }
    }

    public static interface LayerAllocator<T> {
        public static final int LAYERS_COUNT = 256;
        public static final int LAYER_SIZE = 256;

        @Nullable
        public @Nullable T @NotNull [] @Nullable [] allocateLayers();

        public @Nullable T @NotNull [] allocateLayer();
    }
}

