/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.utils;

import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import ru.arturvasilov.sqlite.core.SQLite;
import ru.arturvasilov.sqlite.core.Table;

public class SQLiteUtils {
    private SQLiteUtils() {
    }

    public static <T> boolean isTableEmpty(@NonNull Table<T> table) {
        Cursor cursor = SQLite.get().getContentResolver().query(table.getUri(), new String[]{"count(*) AS count"}, null, null, null);
        try {
            boolean bl = cursor == null || cursor.getCount() == 0 || !cursor.moveToFirst() || cursor.getInt(0) == 0;
            return bl;
        }
        finally {
            SQLiteUtils.safeCloseCursor(cursor);
        }
    }

    public static boolean isEmptyCursor(@Nullable Cursor cursor) {
        if (cursor == null) {
            return true;
        }
        if (cursor.isClosed()) {
            return true;
        }
        return !cursor.moveToFirst();
    }

    public static void safeCloseCursor(@Nullable Cursor cursor) {
        if (cursor == null || cursor.isClosed()) {
            return;
        }
        try {
            cursor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

