/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.rx;

import android.support.annotation.NonNull;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import ru.arturvasilov.sqlite.core.BasicTableObserver;
import ru.arturvasilov.sqlite.core.SQLite;
import ru.arturvasilov.sqlite.core.Table;
import ru.arturvasilov.sqlite.core.Where;
import ru.arturvasilov.sqlite.rx.RxSQLite;

public class TableObservable<T>
extends Observable<Boolean> {
    private final Table<T> mTable;

    TableObservable(@NonNull Table<T> table) {
        this.mTable = table;
    }

    protected void subscribeActual(Observer<? super Boolean> observer) {
        TableListener tableListener = new TableListener(observer);
        observer.onSubscribe((Disposable)tableListener);
        SQLite.get().registerObserver(this.mTable, tableListener);
    }

    @NonNull
    public Observable<List<T>> withQuery() {
        return this.withQuery(Where.create());
    }

    @NonNull
    public Observable<List<T>> withQuery(final @NonNull Where where) {
        return this.flatMap(new Function<Boolean, ObservableSource<List<T>>>(){

            public ObservableSource<List<T>> apply(Boolean value) throws Exception {
                return RxSQLite.get().query(TableObservable.this.mTable, where);
            }
        }).subscribeOn(Schedulers.io());
    }

    private class TableListener
    extends MainThreadDisposable
    implements BasicTableObserver {
        private final Observer<? super Boolean> mObserver;

        TableListener(Observer<? super Boolean> observer) {
            this.mObserver = observer;
        }

        @Override
        public void onTableChanged() {
            this.mObserver.onNext((Object)true);
        }

        protected void onDispose() {
            SQLite.get().unregisterObserver(this);
        }
    }
}

