/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;

public class SQLiteConfig {
    private static final String PREFS_NAME = "sqlite_config_prefs";
    private static final String DATABASE_NAME_KEY = "database_name";
    private static final String AUTHORITY_KEY = "authority";
    private static final String DEFAULT_DATABASE_NAME = "ru.sqlite.database.database";
    private static final String DEFAULT_AUTHORITY = "ru.sqlite.database";
    private final Context mContext;
    private String mDatabaseName;
    private String mAuthority;

    SQLiteConfig(Context context) {
        this.mContext = context;
        SharedPreferences prefs = this.getPrefs();
        this.mDatabaseName = prefs.getString(DATABASE_NAME_KEY, DEFAULT_DATABASE_NAME);
        this.mAuthority = prefs.getString(AUTHORITY_KEY, DEFAULT_AUTHORITY);
    }

    public void setDatabaseName(@NonNull String databaseName) {
        this.mDatabaseName = databaseName;
    }

    public void setAuthority(@NonNull String uri) {
        this.mAuthority = uri;
    }

    @NonNull
    String getDatabaseName() {
        return this.mDatabaseName;
    }

    @NonNull
    String getAuthority() {
        return this.mAuthority;
    }

    @NonNull
    private SharedPreferences getPrefs() {
        return this.mContext.getSharedPreferences(PREFS_NAME, 0);
    }
}

