/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.rx;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import java.util.concurrent.Callable;
import ru.arturvasilov.sqlite.core.BasicTableObserver;
import ru.arturvasilov.sqlite.core.SQLite;
import ru.arturvasilov.sqlite.core.Table;
import ru.arturvasilov.sqlite.core.Where;
import ru.arturvasilov.sqlite.rx.TableObservable;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;
import rx.functions.Func1;

public class RxSQLite {
    private static RxSQLite sSQLite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static RxSQLite get() {
        SQLite.get();
        RxSQLite sqLite = sSQLite;
        if (sqLite != null) return sqLite;
        Class<SQLite> clazz = SQLite.class;
        synchronized (SQLite.class) {
            sqLite = sSQLite;
            if (sqLite != null) return sqLite;
            sSQLite = new RxSQLite();
            return sSQLite;
        }
    }

    @NonNull
    public <T> Observable<List<T>> query(@NonNull Table<T> table) {
        return this.query(table, Where.create());
    }

    @NonNull
    public <T> Observable<List<T>> query(final @NonNull Table<T> table, final @NonNull Where where) {
        return Observable.fromCallable((Callable)new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                return SQLite.get().query(table, where);
            }
        });
    }

    @NonNull
    public <T> Observable<T> querySingle(@NonNull Table<T> table) {
        return this.querySingle(table, Where.create());
    }

    @NonNull
    public <T> Observable<T> querySingle(final @NonNull Table<T> table, final @NonNull Where where) {
        return Observable.fromCallable((Callable)new Callable<T>(){

            @Override
            public T call() throws Exception {
                return SQLite.get().querySingle(table, where);
            }
        }).flatMap(new Func1<T, Observable<T>>(){

            public Observable<T> call(@Nullable T t) {
                return t == null ? Observable.empty() : Observable.just(t);
            }
        }).take(1);
    }

    @NonNull
    public <T> Observable<Uri> insert(final @NonNull Table<T> table, final @NonNull T object) {
        return Observable.fromCallable((Callable)new Callable<Uri>(){

            @Override
            public Uri call() throws Exception {
                return SQLite.get().insert(table, object);
            }
        });
    }

    @NonNull
    public <T> Observable<Integer> insert(final @NonNull Table<T> table, final @NonNull List<T> objects) {
        return Observable.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SQLite.get().insert(table, objects);
            }
        });
    }

    @NonNull
    public <T> Observable<Integer> delete(@NonNull Table<T> table) {
        return this.delete(table, Where.create());
    }

    @NonNull
    public <T> Observable<Integer> delete(final @NonNull Table<T> table, final @NonNull Where where) {
        return Observable.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SQLite.get().delete(table, where);
            }
        });
    }

    @NonNull
    public <T> Observable<Integer> update(final @NonNull Table<T> table, final @NonNull Where where, final @NonNull T newObject) {
        return Observable.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SQLite.get().update(table, where, newObject);
            }
        });
    }

    @NonNull
    public <T> TableObservable<T> observeChanges(final @NonNull Table<T> table) {
        Observable.OnSubscribe<Void> onSubscribe = new Observable.OnSubscribe<Void>(){

            public void call(final Subscriber<? super Void> subscriber) {
                final BasicTableObserver observer = new BasicTableObserver(){

                    @Override
                    public void onTableChanged() {
                        if (subscriber != null && !subscriber.isUnsubscribed()) {
                            subscriber.onNext(null);
                        }
                    }
                };
                subscriber.add((Subscription)new MainThreadSubscription(){

                    protected void onUnsubscribe() {
                        SQLite.get().unregisterObserver(observer);
                    }
                });
                SQLite.get().registerObserver(table, observer);
            }
        };
        return new TableObservable<T>(onSubscribe, table);
    }
}

