/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.rx;

import android.support.annotation.NonNull;
import java.util.List;
import ru.arturvasilov.sqlite.core.Table;
import ru.arturvasilov.sqlite.core.Where;
import ru.arturvasilov.sqlite.rx.RxSQLite;
import rx.Observable;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

class TableObservable<T>
extends Observable<Void> {
    private final Table<T> mTable;

    TableObservable(@NonNull Observable.OnSubscribe<Void> f, @NonNull Table<T> table) {
        super(f);
        this.mTable = table;
    }

    @NonNull
    public Observable<List<T>> withQuery() {
        return this.withQuery(Where.create());
    }

    @NonNull
    public Observable<List<T>> withQuery(final @NonNull Where where) {
        return this.flatMap(new Func1<Void, Observable<List<T>>>(){

            public Observable<List<T>> call(Void value) {
                return RxSQLite.get().query(TableObservable.this.mTable, where);
            }
        }).subscribeOn(Schedulers.io());
    }
}

