/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.Context;
import android.support.annotation.NonNull;
import org.sqlite.database.sqlite.SQLiteDatabase;
import org.sqlite.database.sqlite.SQLiteOpenHelper;
import ru.arturvasilov.sqlite.core.SQLiteConfig;
import ru.arturvasilov.sqlite.core.SQLiteSchema;
import ru.arturvasilov.sqlite.core.Table;

class SQLiteHelper
extends SQLiteOpenHelper {
    private final SQLiteSchema mSchema;

    public SQLiteHelper(Context context, @NonNull SQLiteConfig config, @NonNull SQLiteSchema schema) {
        super(context, context.getDatabasePath(config.getDatabaseName()).getPath(), null, schema.calculateVersion());
        this.mSchema = schema;
        context.openOrCreateDatabase(config.getDatabaseName(), 0, null, null);
    }

    public void onCreate(SQLiteDatabase database) {
        for (Table table : this.mSchema) {
            table.onCreate(database);
        }
    }

    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        for (Table table : this.mSchema) {
            if (oldVersion >= newVersion || newVersion > table.getLastUpgradeVersion()) continue;
            table.onUpgrade(database);
        }
    }
}

