/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.utils;

import android.support.annotation.NonNull;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ru.arturvasilov.sqlite.utils.MainHandler;

public final class ThreadUtils {
    private static final long RETRY_DELAY = 100L;
    private static final int POOL_SIZE = 2;
    private static final int KEEP_ALIVE_TIME = 10;
    private static final RejectedExecutionHandler REJECTED_EXECUTION_HANDLER = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(final Runnable runnable, final ThreadPoolExecutor executor) {
            MainHandler.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    executor.execute(runnable);
                }
            }, 100L);
        }
    };
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2), REJECTED_EXECUTION_HANDLER);

    private ThreadUtils() {
    }

    public static void runInBackground(@NonNull Runnable runnable) {
        THREAD_POOL_EXECUTOR.execute(runnable);
    }
}

