/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.utils;

import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import ru.arturvasilov.sqlite.core.Table;

public final class TableBuilder {
    private String mTableName;
    private final List<String> mPrimaryKeys;
    private final List<String> mIntegerColumns = new ArrayList<String>();
    private final List<String> mStringColumns = new ArrayList<String>();

    private TableBuilder() {
        this.mPrimaryKeys = new ArrayList<String>();
    }

    @NonNull
    public static TableBuilder create(@NonNull Table table) {
        TableBuilder builder = new TableBuilder();
        builder.mTableName = table.getTableName();
        return builder;
    }

    @NonNull
    public TableBuilder primaryKey(String ... keys) {
        this.mPrimaryKeys.clear();
        Collections.addAll(this.mPrimaryKeys, keys);
        return this;
    }

    @NonNull
    public TableBuilder intColumn(@NonNull String columnName) {
        this.mIntegerColumns.add(columnName);
        return this;
    }

    @NonNull
    public TableBuilder stringColumn(@NonNull String columnName) {
        this.mStringColumns.add(columnName);
        return this;
    }

    public void execute(@NonNull SQLiteDatabase database) {
        Iterator<String> column;
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE IF NOT EXISTS ").append(this.mTableName).append("(");
        if (this.mStringColumns.isEmpty() && this.mIntegerColumns.isEmpty()) {
            throw new IllegalStateException("No columns present");
        }
        if (this.mIntegerColumns.isEmpty()) {
            column = this.mStringColumns.remove(0);
            builder.append((String)((Object)column)).append(" TEXT");
        } else {
            column = this.mIntegerColumns.remove(0);
            builder.append((String)((Object)column)).append(" INTEGER");
        }
        for (String column2 : this.mStringColumns) {
            builder.append(", ").append(column2).append(" TEXT");
        }
        for (String column2 : this.mIntegerColumns) {
            builder.append(", ").append(column2).append(" INTEGER");
        }
        if (!this.mPrimaryKeys.isEmpty()) {
            builder.append(", PRIMARY KEY (").append(this.mPrimaryKeys.get(0));
        }
        for (int i = 1; i < this.mPrimaryKeys.size(); ++i) {
            builder.append(", ").append(this.mPrimaryKeys.get(i));
        }
        if (!this.mPrimaryKeys.isEmpty()) {
            builder.append(")");
        }
        builder.append(");");
        database.execSQL(builder.toString());
    }
}

