/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import ru.arturvasilov.sqlite.core.SQLiteConfig;
import ru.arturvasilov.sqlite.core.Schema;
import ru.arturvasilov.sqlite.core.Table;

class SQLiteHelper
extends SQLiteOpenHelper {
    private final Schema mSchema;

    public SQLiteHelper(Context context, @NonNull SQLiteConfig config, @NonNull Schema schema) {
        super(context, config.getDatabaseName(), null, schema.calculateVersion());
        this.mSchema = schema;
    }

    public void onCreate(SQLiteDatabase db) {
        for (Table table : this.mSchema) {
            table.onCreate(db);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        for (Table table : this.mSchema) {
            table.onUpgrade(db, oldVersion, newVersion);
        }
    }
}

