/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import ru.arturvasilov.sqlite.utils.SQLiteUtils;

public class SQLiteConfig {
    private static final String PREFS_NAME = "sqlite_config_prefs";
    private static final String DATABASE_NAME_KEY = "database_name";
    private static final String AUTHORITY_KEY = "authority";
    private final Context mContext;
    private String mDatabaseName;
    private String mAuthority;

    public SQLiteConfig(Context context) {
        this.mContext = context;
        SharedPreferences prefs = this.getPrefs();
        this.mDatabaseName = prefs.getString(DATABASE_NAME_KEY, SQLiteUtils.defaultDatabaseName());
        this.mAuthority = prefs.getString(AUTHORITY_KEY, SQLiteUtils.defaultUri());
    }

    @NonNull
    public String getDatabaseName() {
        return this.mDatabaseName;
    }

    public void setDatabaseName(@NonNull String databaseName) {
        this.mDatabaseName = databaseName;
    }

    @NonNull
    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(@NonNull String uri) {
        this.mAuthority = uri;
    }

    @NonNull
    private SharedPreferences getPrefs() {
        return this.mContext.getSharedPreferences(PREFS_NAME, 0);
    }
}

