/*
 * Decompiled with CFR 0.152.
 */
package ru.arturvasilov.sqlite.rx;

import android.support.annotation.NonNull;
import java.util.List;
import ru.arturvasilov.sqlite.core.Table;
import ru.arturvasilov.sqlite.core.Where;
import ru.arturvasilov.sqlite.rx.RxSQLite;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class TableObservable<T>
extends Observable<Boolean> {
    private final Table<T> mTable;

    public TableObservable(@NonNull Observable.OnSubscribe<Boolean> f, @NonNull Table<T> table) {
        super(f);
        this.mTable = table;
    }

    @NonNull
    public Observable<List<T>> withQuery() {
        return this.flatMap(new Func1<Boolean, Observable<List<T>>>(){

            public Observable<List<T>> call(Boolean value) {
                return RxSQLite.get().query(TableObservable.this.mTable, Where.create());
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }
}

