/*
 * Decompiled with CFR 0.152.
 */
package processing.awt;

import java.awt.Desktop;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import processing.awt.PImageAWT;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class ShimAWT
implements PConstants {
    private static ShimAWT instance;
    private GraphicsDevice[] displayDevices;
    private int displayWidth;
    private int displayHeight;
    protected static String[] loadImageFormats;
    protected static String[] saveImageFormats;
    private static boolean lookAndFeelCheck;

    private static ShimAWT getInstance() {
        if (instance == null) {
            instance = new ShimAWT();
        }
        return instance;
    }

    private ShimAWT() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        this.displayDevices = ge.getScreenDevices();
        DisplayMode displayMode = device.getDisplayMode();
        this.displayWidth = displayMode.getWidth();
        this.displayHeight = displayMode.getHeight();
    }

    public static int getDisplayWidth() {
        return ShimAWT.getInstance().displayWidth;
    }

    public static int getDisplayHeight() {
        return ShimAWT.getInstance().displayHeight;
    }

    public static int getDisplayCount() {
        return ShimAWT.getInstance().displayDevices.length;
    }

    public static int getDisplayDensity(int num) {
        return ShimAWT.getInstance().displayDensityImpl(num);
    }

    private int displayDensityImpl(int display) {
        if (display > 0 && display <= this.displayDevices.length) {
            GraphicsConfiguration graphicsConfig = this.displayDevices[display - 1].getDefaultConfiguration();
            AffineTransform tx = graphicsConfig.getDefaultTransform();
            return (int)Math.round(tx.getScaleX());
        }
        System.err.println("Display " + display + " does not exist, returning 1 for displayDensity(" + display + ")");
        return 1;
    }

    public static PImage loadImage(PApplet sketch, String filename, Object ... args) {
        InputStream input;
        String extension = null;
        if (args != null && args.length > 0) {
            extension = (String)args[0];
        }
        if (extension == null) {
            String lower = filename.toLowerCase();
            int dot = filename.lastIndexOf(46);
            if (dot == -1) {
                extension = "unknown";
            } else {
                extension = lower.substring(dot + 1);
                int question = extension.indexOf(63);
                if (question != -1) {
                    extension = extension.substring(0, question);
                }
            }
        }
        if ((extension = extension.toLowerCase()).equals("tga")) {
            try {
                input = sketch.createInput(filename);
                if (input == null) {
                    return null;
                }
                PImage image = PImage.loadTGA(input);
                image.parent = sketch;
                return image;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (extension.equals("tif") || extension.equals("tiff")) {
            input = sketch.createInput(filename);
            PImage image = input == null ? null : PImage.loadTIFF(input);
            return image;
        }
        try {
            if (extension.equals("jpg") || extension.equals("jpeg") || extension.equals("gif") || extension.equals("png") || extension.equals("unknown")) {
                BufferedImage buffImage;
                int space;
                byte[] bytes = sketch.loadBytes(filename);
                if (bytes == null) {
                    return null;
                }
                Image awtImage = new ImageIcon(bytes).getImage();
                if (awtImage instanceof BufferedImage && (space = (buffImage = (BufferedImage)awtImage).getColorModel().getColorSpace().getType()) == 9) {
                    System.err.println(filename + " is a CMYK image, only RGB images are supported.");
                    return null;
                }
                PImageAWT image = new PImageAWT(awtImage);
                if (image.width == -1) {
                    System.err.println("The file " + filename + " contains bad image data, or may not be an image.");
                }
                if (extension.equals("gif") || extension.equals("png") || extension.equals("unknown")) {
                    image.checkAlpha();
                }
                image.parent = sketch;
                return image;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (loadImageFormats == null) {
            loadImageFormats = ImageIO.getReaderFormatNames();
        }
        if (loadImageFormats != null) {
            for (int i = 0; i < loadImageFormats.length; ++i) {
                if (!extension.equals(loadImageFormats[i])) continue;
                return ShimAWT.loadImageIO(sketch, filename);
            }
        }
        System.err.println("Could not find a method to load " + filename);
        return null;
    }

    protected static PImage loadImageIO(PApplet sketch, String filename) {
        InputStream stream = sketch.createInput(filename);
        if (stream == null) {
            System.err.println("The image " + filename + " could not be found.");
            return null;
        }
        try {
            BufferedImage bi = ImageIO.read(stream);
            PImageAWT outgoing = new PImageAWT(bi);
            outgoing.parent = sketch;
            outgoing.checkAlpha();
            stream.close();
            return outgoing;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean saveImage(PImage image, String path) {
        if (saveImageFormats == null) {
            saveImageFormats = ImageIO.getWriterFormatNames();
        }
        try {
            if (saveImageFormats != null) {
                for (int i = 0; i < saveImageFormats.length; ++i) {
                    if (!path.endsWith("." + saveImageFormats[i])) continue;
                    if (!ShimAWT.saveImageIO(image, path)) {
                        System.err.println("Error while saving image.");
                        return false;
                    }
                    return true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected static boolean saveImageIO(PImage image, String path) throws IOException {
        try {
            int outputFormat = image.format == 2 ? 2 : 1;
            String extension = path.substring(path.lastIndexOf(46) + 1).toLowerCase();
            if (extension.equals("bmp") || extension.equals("jpg") || extension.equals("jpeg")) {
                outputFormat = 1;
            }
            BufferedImage bimage = new BufferedImage(image.pixelWidth, image.pixelHeight, outputFormat);
            bimage.setRGB(0, 0, image.pixelWidth, image.pixelHeight, image.pixels, 0, image.pixelWidth);
            File file = new File(path);
            ImageWriter writer = null;
            ImageWriteParam param = null;
            IIOMetadata metadata = null;
            if ((extension.equals("jpg") || extension.equals("jpeg")) && (writer = ShimAWT.imageioWriter("jpeg")) != null) {
                param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(0.9f);
            }
            if (extension.equals("png") && (writer = ShimAWT.imageioWriter("png")) != null) {
                param = writer.getDefaultWriteParam();
            }
            if (writer != null) {
                BufferedOutputStream output = new BufferedOutputStream(PApplet.createOutput(file));
                writer.setOutput(ImageIO.createImageOutputStream(output));
                writer.write(metadata, new IIOImage(bimage, null, metadata), param);
                writer.dispose();
                output.flush();
                output.close();
                return true;
            }
            return ImageIO.write((RenderedImage)bimage, extension, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("image save failed.");
        }
    }

    private static ImageWriter imageioWriter(String extension) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(extension);
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    private static IIOMetadata imageioDPI(ImageWriter writer, ImageWriteParam param, double dpi) {
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, param);
        if (!metadata.isReadOnly() && metadata.isStandardMetadataFormatSupported()) {
            double dotsPerMilli = dpi / 25.4;
            IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
            horiz.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
            vert.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode dim = new IIOMetadataNode("Dimension");
            dim.appendChild(horiz);
            dim.appendChild(vert);
            IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
            root.appendChild(dim);
            try {
                metadata.mergeTree("javax_imageio_1.0", root);
                return metadata;
            }
            catch (IIOInvalidTreeException e) {
                System.err.println("Could not set the DPI of the output image");
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void initRun() {
        System.setProperty("sun.awt.noerasebackground", "true");
        System.setProperty("javafx.animation.fullspeed", "true");
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }
        catch (HeadlessException e) {
            System.err.println("Cannot run sketch without a display. Read this for possible solutions:");
            System.err.println("https://github.com/processing/processing/wiki/Running-without-a-Display");
            System.exit(1);
        }
    }

    public static void selectInput(String prompt, String callbackMethod, File file, Object callbackObject) {
        EventQueue.invokeLater(() -> ShimAWT.selectImpl(prompt, callbackMethod, file, callbackObject, null, 0));
    }

    public static void selectOutput(String prompt, String callbackMethod, File file, Object callbackObject) {
        EventQueue.invokeLater(() -> ShimAWT.selectImpl(prompt, callbackMethod, file, callbackObject, null, 1));
    }

    public static void selectImpl(String prompt, String callbackMethod, File defaultSelection, Object callbackObject, Frame parentFrame, int mode) {
        File selectedFile = null;
        if (PApplet.useNativeSelect) {
            FileDialog dialog = new FileDialog(parentFrame, prompt, mode);
            if (defaultSelection != null) {
                dialog.setDirectory(defaultSelection.getParent());
                dialog.setFile(defaultSelection.getName());
            }
            dialog.setVisible(true);
            String directory = dialog.getDirectory();
            String filename = dialog.getFile();
            if (filename != null) {
                selectedFile = new File(directory, filename);
            }
        } else {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(prompt);
            if (defaultSelection != null) {
                chooser.setSelectedFile(defaultSelection);
            }
            int result = -1;
            if (mode == 1) {
                result = chooser.showSaveDialog(parentFrame);
            } else if (mode == 0) {
                result = chooser.showOpenDialog(parentFrame);
            }
            if (result == 0) {
                selectedFile = chooser.getSelectedFile();
            }
        }
        PApplet.selectCallback(selectedFile, callbackMethod, callbackObject);
    }

    public static void selectFolder(String prompt, String callbackMethod, File defaultSelection, Object callbackObject) {
        EventQueue.invokeLater(() -> ShimAWT.selectFolderImpl(prompt, callbackMethod, defaultSelection, callbackObject, null));
    }

    public static void selectFolderImpl(String prompt, String callbackMethod, File defaultSelection, Object callbackObject, Frame parentFrame) {
        File selectedFile = null;
        if (PApplet.platform == 2 && PApplet.useNativeSelect) {
            FileDialog fileDialog = new FileDialog(parentFrame, prompt, 0);
            if (defaultSelection != null) {
                fileDialog.setDirectory(defaultSelection.getAbsolutePath());
            }
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String filename = fileDialog.getFile();
            if (filename != null) {
                selectedFile = new File(fileDialog.getDirectory(), fileDialog.getFile());
            }
        } else {
            int result;
            ShimAWT.checkLookAndFeel();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(prompt);
            fileChooser.setFileSelectionMode(1);
            if (defaultSelection != null) {
                fileChooser.setCurrentDirectory(defaultSelection);
            }
            if ((result = fileChooser.showOpenDialog(parentFrame)) == 0) {
                selectedFile = fileChooser.getSelectedFile();
            }
        }
        PApplet.selectCallback(selectedFile, callbackMethod, callbackObject);
    }

    private static void checkLookAndFeel() {
        if (!lookAndFeelCheck) {
            if (PApplet.platform == 1) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            lookAndFeelCheck = true;
        }
    }

    public static File getWindowsDesktop() {
        return FileSystemView.getFileSystemView().getHomeDirectory();
    }

    public static boolean openLink(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return false;
    }
}

