/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.validation;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.MavenLoggerBridge;
import pl.project13.maven.validation.ValidationProperty;

@org.apache.maven.plugins.annotations.Mojo(name="validateRevision", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class ValidationMojo
extends AbstractMojo {
    @Nonnull
    private final LoggerBridge log = new MavenLoggerBridge((Mojo)this, false);
    @Parameter(defaultValue="true")
    private boolean validationShouldFailIfNoMatch;
    @Parameter
    private List<ValidationProperty> validationProperties;

    public void execute() throws MojoExecutionException {
        if (this.validationProperties != null && this.validationShouldFailIfNoMatch) {
            for (ValidationProperty validationProperty : this.validationProperties) {
                String name = validationProperty.getName();
                String value = validationProperty.getValue();
                String shouldMatchTo = validationProperty.getShouldMatchTo();
                if (value != null && shouldMatchTo != null) {
                    this.validateIfValueAndShouldMatchToMatches(name, value, shouldMatchTo);
                    continue;
                }
                this.printLogMessageWhenValueOrShouldMatchToIsEmpty(name, value, shouldMatchTo);
            }
        }
    }

    private void validateIfValueAndShouldMatchToMatches(String name, String value, String shouldMatchTo) throws MojoExecutionException {
        Pattern pattern = Pattern.compile(shouldMatchTo);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.find()) {
            String commonLogMessage = "Expected '" + value + "' to match with '" + shouldMatchTo + "'!";
            if (name != null) {
                throw new MojoExecutionException("Validation '" + name + "' failed! " + commonLogMessage);
            }
            throw new MojoExecutionException("Validation of an unidentified validation (please set the name property-tag to be able to identify the validation) failed! " + commonLogMessage);
        }
    }

    private void printLogMessageWhenValueOrShouldMatchToIsEmpty(String name, String value, String shouldMatchTo) {
        String commonLogMessage = "since one of the values was null! (value = '" + value + "'; shouldMatchTo = '" + shouldMatchTo + "').";
        if (name != null) {
            this.log.warn("Skipping validation '" + name + "' " + commonLogMessage);
        } else {
            this.log.warn("Skipping an unidentified validation (please set the name property-tag to be able to identify the validation) " + commonLogMessage);
        }
    }

    public void setValidationShouldFailIfNoMatch(boolean validationShouldFailIfNoMatch) {
        this.validationShouldFailIfNoMatch = validationShouldFailIfNoMatch;
    }

    public void setValidationProperties(List<ValidationProperty> validationProperties) {
        this.validationProperties = validationProperties;
    }
}

