// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.sync;

import java.util.LinkedList;
import java.util.List;
import org.smartparam.engine.util.Printer;
import pl.decerto.hyperon.persistence.model.value.EntityProperty;
import pl.decerto.hyperon.persistence.model.value.RefProperty;

/**
 * @author przemek hertel
 */
public class SyncActions {
	/**
	 * entities to insert
	 */
	private final List<EntityProperty> toInsert = new LinkedList<>();
	/**
	 * entities to update [next value]
	 */
	private final List<EntityProperty> toUpdate = new LinkedList<>();
	/**
	 * entities to update [prev value]
	 */
	private final List<EntityProperty> toUpdatePrev = new LinkedList<>();
	/**
	 * entities to delete
	 */
	private final List<EntityProperty> toDelete = new LinkedList<>();
	/**
	 * all refs that are present in [next] bundle
	 */
	private List<RefProperty> refs = new LinkedList<>();

	void toInsert(EntityProperty e) {
		toInsert.add(e);
	}

	void toUpdate(EntityProperty prev, EntityProperty next) {
		toUpdatePrev.add(prev);
		toUpdate.add(next);
	}

	void toDelete(EntityProperty e) {
		toDelete.add(e);
	}

	void toRef(RefProperty r) {
		refs.add(r);
	}

	public boolean hasInsert() {
		return !toInsert.isEmpty();
	}

	public boolean hasUpdate() {
		return !toUpdate.isEmpty();
	}

	public boolean hasDelete() {
		return !toDelete.isEmpty();
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(64);
		sb.append("SyncActions[");
		sb.append("insert:").append(toInsert.size());
		sb.append(", update:").append(toUpdate.size());
		sb.append(", delete:").append(toDelete.size());
		print(sb, toInsert, "toInsert");
		print(sb, toUpdate, "toUpdate");
		print(sb, toDelete, "toDelete");
		sb.append(']');
		return sb.toString();
	}

	private void print(StringBuilder sb, List<EntityProperty> list, String name) {
		if (!list.isEmpty()) {
			sb.append(Printer.print(list, name, 20, o -> {
				EntityProperty e = (EntityProperty) o;
				return e.printValues();
			}));
		}
	}

	/**
	 * entities to insert
	 */
	@java.lang.SuppressWarnings("all")
	public List<EntityProperty> getToInsert() {
		return this.toInsert;
	}

	/**
	 * entities to update [next value]
	 */
	@java.lang.SuppressWarnings("all")
	public List<EntityProperty> getToUpdate() {
		return this.toUpdate;
	}

	/**
	 * entities to update [prev value]
	 */
	@java.lang.SuppressWarnings("all")
	public List<EntityProperty> getToUpdatePrev() {
		return this.toUpdatePrev;
	}

	/**
	 * entities to delete
	 */
	@java.lang.SuppressWarnings("all")
	public List<EntityProperty> getToDelete() {
		return this.toDelete;
	}

	/**
	 * all refs that are present in [next] bundle
	 */
	@java.lang.SuppressWarnings("all")
	public List<RefProperty> getRefs() {
		return this.refs;
	}
}
