package pl.decerto.hyperon.persistence.proxy;

import pl.decerto.hyperon.persistence.model.def.BundleDef;

/**
 * @author przemek hertel
 */
public class HyperonPersistence {

	private static BundleDef defaultBundleDef;

	private ThreadLocal<BundleDef> threadBundleDef = new ThreadLocal<>();

	public static BundleDef getBundleDef() {

		// thread bound
		BundleDef def = getDefaultBundleDef();

		// global defalt
		if (def == null) {
			def = defaultBundleDef;
		}

		return def;
	}

	public static BundleDef getDefaultBundleDef() {
		return defaultBundleDef;
	}

	public static void setDefaultBundleDef(BundleDef defaultBundleDef) {
		HyperonPersistence.defaultBundleDef = defaultBundleDef;
	}

	public void setThreadBundleDef(BundleDef def) {
		threadBundleDef.set(def);
	}

	public void clearThreadBundleDef() {
		threadBundleDef.remove();
	}

	public BundleDef getThreadBundleDef() {
		return threadBundleDef.get();
	}
}
