// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.cache.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Maciej Główka on 14.05.2020
 */
public class BundleTableMetadataDto {
	private final Map<String, ColumnMetadataDto> tableNameToColumnMapping = new HashMap<>();

	public void put(String tableName, ColumnMetadataDto columnMetadata) {
		if (Objects.isNull(tableName)) {
			throw new IllegalArgumentException("table name cannot be null");
		}
		tableNameToColumnMapping.put(StringUtils.upperCase(tableName), columnMetadata);
	}

	public Optional<ColumnMetadataDto> getColumnMetadata(String tableName) {
		return Optional.ofNullable(tableNameToColumnMapping.get(StringUtils.upperCase(tableName)));
	}

	public int getTablesCount() {
		return tableNameToColumnMapping.size();
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public java.lang.String toString() {
		return "BundleTableMetadataDto(tableNameToColumnMapping=" + this.tableNameToColumnMapping + ")";
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof BundleTableMetadataDto)) return false;
		final BundleTableMetadataDto other = (BundleTableMetadataDto) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		final java.lang.Object this$tableNameToColumnMapping = this.tableNameToColumnMapping;
		final java.lang.Object other$tableNameToColumnMapping = other.tableNameToColumnMapping;
		if (this$tableNameToColumnMapping == null ? other$tableNameToColumnMapping != null : !this$tableNameToColumnMapping.equals(other$tableNameToColumnMapping)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof BundleTableMetadataDto;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final java.lang.Object $tableNameToColumnMapping = this.tableNameToColumnMapping;
		result = result * PRIME + ($tableNameToColumnMapping == null ? 43 : $tableNameToColumnMapping.hashCode());
		return result;
	}
}
