package pl.decerto.hyperon.persistence.cache;

import pl.decerto.hyperon.persistence.model.value.Bundle;

/**
 * @author przemek hertel
 */
public interface BundleCache extends Invalidable {

	/** get Bundle with given {@code id} from cache
	 *
	 * @param id bundle id to get from cache
	 * @return bundle or null, if there is no bundle with given {@code id} in cache
	 */
	Bundle get(long id);

	/**
	 * add bundle to cache
	 *
	 * @param bundle to store in cache
	 */
	void put(Bundle bundle);

	/**
	 * removes bundle with given {@code id} from cache. Nothing happens if there is no bundle with given {@code id} in cache
	 *
	 * @param id bundle id to remove
	 */
	void remove(long id);

	/**
	 * prints String representation of whole cache state
	 *
	 * @return String representation of whole cache state
	 */
	String print();

}
