/*
 * Decompiled with CFR 0.152.
 */
package pl.charmas.android.reactivelocation.observables.location;

import android.content.Context;
import android.location.Location;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationServices;
import pl.charmas.android.reactivelocation.observables.BaseLocationObservable;
import pl.charmas.android.reactivelocation.observables.StatusException;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;

public class MockLocationObservable
extends BaseLocationObservable<Status> {
    private Observable<Location> locationObservable;
    private Subscription mockLocationSubscription;

    public static Observable<Status> createObservable(Context context, Observable<Location> locationObservable) {
        return Observable.create((Observable.OnSubscribe)new MockLocationObservable(context, locationObservable));
    }

    protected MockLocationObservable(Context ctx, Observable<Location> locationObservable) {
        super(ctx);
        this.locationObservable = locationObservable;
    }

    @Override
    protected void onGoogleApiClientReady(final GoogleApiClient apiClient, final Observer<? super Status> observer) {
        LocationServices.FusedLocationApi.setMockMode(apiClient, true).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(Status status) {
                if (!status.isSuccess()) {
                    observer.onError((Throwable)new StatusException(status));
                } else {
                    MockLocationObservable.this.startLocationMocking(apiClient, (Observer<? super Status>)observer);
                }
            }
        });
    }

    private void startLocationMocking(final GoogleApiClient apiClient, final Observer<? super Status> observer) {
        this.mockLocationSubscription = this.locationObservable.subscribe((Action1)new Action1<Location>(){

            public void call(Location location) {
                LocationServices.FusedLocationApi.setMockLocation(apiClient, location).setResultCallback((ResultCallback)new ResultCallback<Status>(){

                    public void onResult(Status status) {
                        if (!status.isSuccess()) {
                            observer.onError((Throwable)new StatusException(status));
                        } else {
                            observer.onNext((Object)status);
                        }
                    }
                });
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                observer.onError(throwable);
            }
        }, new Action0(){

            public void call() {
                observer.onCompleted();
            }
        });
    }

    @Override
    protected void onUnsubscribed(GoogleApiClient locationClient) {
        if (locationClient.isConnected()) {
            try {
                LocationServices.FusedLocationApi.setMockMode(locationClient, false);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.mockLocationSubscription != null && !this.mockLocationSubscription.isUnsubscribed()) {
            this.mockLocationSubscription.unsubscribe();
        }
    }
}

