/*
 * Decompiled with CFR 0.152.
 */
package pl.charmas.android.reactivelocation.observables.geofence;

import android.app.PendingIntent;
import android.content.Context;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationServices;
import pl.charmas.android.reactivelocation.observables.StatusException;
import pl.charmas.android.reactivelocation.observables.geofence.RemoveGeofenceObservable;
import rx.Observer;

class RemoveGeofenceByPendingIntentObservable
extends RemoveGeofenceObservable<Status> {
    private final PendingIntent pendingIntent;

    RemoveGeofenceByPendingIntentObservable(Context ctx, PendingIntent pendingIntent) {
        super(ctx);
        this.pendingIntent = pendingIntent;
    }

    @Override
    protected void removeGeofences(GoogleApiClient locationClient, final Observer<? super Status> observer) {
        LocationServices.GeofencingApi.removeGeofences(locationClient, this.pendingIntent).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(Status status) {
                if (status.isSuccess()) {
                    observer.onNext((Object)status);
                    observer.onCompleted();
                } else {
                    observer.onError((Throwable)new StatusException(status));
                }
            }
        });
    }
}

