/*
 * Decompiled with CFR 0.152.
 */
package pl.charmas.android.reactivelocation.observables.geocode;

import android.location.Address;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;
import rx.Subscriber;

class FallbackReverseGeocodeObservable
implements Observable.OnSubscribe<List<Address>> {
    private final Locale locale;
    private final double latitude;
    private final double longitude;
    private final int maxResults;

    FallbackReverseGeocodeObservable(Locale locale, double latitude, double longitude, int maxResults) {
        this.locale = locale;
        this.latitude = latitude;
        this.longitude = longitude;
        this.maxResults = maxResults;
    }

    public void call(Subscriber<? super List<Address>> subscriber) {
        try {
            subscriber.onNext(this.alternativeReverseGeocodeQuery());
            subscriber.onCompleted();
        }
        catch (Exception ex) {
            subscriber.onError((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Address> alternativeReverseGeocodeQuery() throws IOException, JSONException {
        URL url = new URL(String.format(Locale.ENGLISH, "http://maps.googleapis.com/maps/api/geocode/json?latlng=%1$f,%2$f&sensor=true&language=%3$s", this.latitude, this.longitude, this.locale.getLanguage()));
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Address> outResult = new ArrayList<Address>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            JSONObject jsonRootObject = new JSONObject(stringBuilder.toString());
            if ("ZERO_RESULTS".equalsIgnoreCase(jsonRootObject.getString("status"))) {
                List<Address> list = Collections.emptyList();
                return list;
            }
            if (!"OK".equalsIgnoreCase(jsonRootObject.getString("status"))) {
                throw new RuntimeException("Wrong API response");
            }
            JSONArray results = jsonRootObject.getJSONArray("results");
            for (int i = 0; i < results.length() && i < this.maxResults; ++i) {
                Address address = new Address(Locale.getDefault());
                String addressLineString = "";
                JSONObject sourceResult = results.getJSONObject(i);
                JSONArray addressComponents = sourceResult.getJSONArray("address_components");
                for (int ac = 0; ac < addressComponents.length(); ++ac) {
                    String longNameVal = addressComponents.getJSONObject(ac).getString("long_name");
                    String shortNameVal = addressComponents.getJSONObject(ac).getString("short_name");
                    JSONArray acTypes = addressComponents.getJSONObject(ac).getJSONArray("types");
                    String acType = acTypes.getString(0);
                    if (TextUtils.isEmpty((CharSequence)longNameVal)) continue;
                    if (acType.equalsIgnoreCase("street_number")) {
                        if (TextUtils.isEmpty((CharSequence)addressLineString)) {
                            addressLineString = longNameVal;
                            continue;
                        }
                        addressLineString = addressLineString + " " + longNameVal;
                        continue;
                    }
                    if (acType.equalsIgnoreCase("route")) {
                        if (TextUtils.isEmpty((CharSequence)addressLineString)) {
                            addressLineString = longNameVal;
                            continue;
                        }
                        addressLineString = longNameVal + " " + addressLineString;
                        continue;
                    }
                    if (acType.equalsIgnoreCase("sublocality")) {
                        address.setSubLocality(longNameVal);
                        continue;
                    }
                    if (acType.equalsIgnoreCase("locality")) {
                        address.setLocality(longNameVal);
                        continue;
                    }
                    if (acType.equalsIgnoreCase("administrative_area_level_2")) {
                        address.setSubAdminArea(longNameVal);
                        continue;
                    }
                    if (acType.equalsIgnoreCase("administrative_area_level_1")) {
                        address.setAdminArea(longNameVal);
                        continue;
                    }
                    if (acType.equalsIgnoreCase("country")) {
                        address.setCountryName(longNameVal);
                        address.setCountryCode(shortNameVal);
                        continue;
                    }
                    if (!acType.equalsIgnoreCase("postal_code")) continue;
                    address.setPostalCode(longNameVal);
                }
                String formattedAddress = sourceResult.getString("formatted_address");
                if (!TextUtils.isEmpty((CharSequence)formattedAddress)) {
                    String[] formattedAddressLines = formattedAddress.split(",");
                    for (int ia = 0; ia < formattedAddressLines.length; ++ia) {
                        address.setAddressLine(ia, formattedAddressLines[ia].trim());
                    }
                } else if (!TextUtils.isEmpty((CharSequence)addressLineString)) {
                    address.setAddressLine(0, addressLineString);
                }
                outResult.add(address);
            }
        }
        finally {
            urlConnection.disconnect();
        }
        return Collections.unmodifiableList(outResult);
    }
}

