/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.boot.autoconfigure.handlebars;

import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import com.github.jknack.handlebars.springmvc.HandlebarsViewResolver;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.template.AbstractTemplateViewResolverProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.util.Assert;
import pl.allegro.tech.boot.autoconfigure.handlebars.HandlebarsValueResolversProperties;

@ConfigurationProperties(prefix="handlebars")
@EnableConfigurationProperties(value={HandlebarsValueResolversProperties.class})
public class HandlebarsProperties
extends AbstractTemplateViewResolverProperties {
    static final String DEFAULT_PREFIX = "classpath:templates/";
    static final String DEFAULT_SUFFIX = ".hbs";
    private final HandlebarsValueResolversProperties valueResolversProperties;

    @Autowired
    protected HandlebarsProperties(HandlebarsValueResolversProperties valueResolversProperties) {
        super(DEFAULT_PREFIX, DEFAULT_SUFFIX);
        this.valueResolversProperties = valueResolversProperties;
        this.setCache(true);
    }

    public void applyToViewResolver(Object viewResolver) {
        super.applyToViewResolver(viewResolver);
        Assert.isInstanceOf(HandlebarsViewResolver.class, (Object)viewResolver, (String)("ViewResolver is not an instance of HandlebarsViewResolver :" + viewResolver));
        ArrayList<ValueResolver> valueResolvers = new ArrayList<ValueResolver>();
        this.addValueResolverIfNeeded(valueResolvers, this.valueResolversProperties.isJavaBean(), JavaBeanValueResolver.INSTANCE);
        this.addValueResolverIfNeeded(valueResolvers, this.valueResolversProperties.isMap(), (ValueResolver)MapValueResolver.INSTANCE);
        this.addValueResolverIfNeeded(valueResolvers, this.valueResolversProperties.isField(), FieldValueResolver.INSTANCE);
        this.addValueResolverIfNeeded(valueResolvers, this.valueResolversProperties.isMethod(), MethodValueResolver.INSTANCE);
        ((HandlebarsViewResolver)viewResolver).setValueResolvers(this.listToArray(valueResolvers));
    }

    private void addValueResolverIfNeeded(List<ValueResolver> resolvers, boolean property, ValueResolver resolver) {
        if (property) {
            resolvers.add(resolver);
        }
    }

    private ValueResolver[] listToArray(List<ValueResolver> resolvers) {
        return resolvers.toArray(new ValueResolver[resolvers.size()]);
    }
}

