/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.boot.autoconfigure.handlebars;

import com.github.jknack.handlebars.cache.GuavaTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.springmvc.HandlebarsViewResolver;
import com.google.common.cache.CacheBuilder;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.boot.autoconfigure.handlebars.HandlebarsProperties;

@Configuration
@EnableConfigurationProperties(value={HandlebarsProperties.class})
@ConditionalOnWebApplication
public class HandlebarsAutoConfiguration {

    @Configuration
    protected static class HandlebarsCacheConfiguration {
        @Autowired
        private HandlebarsViewResolver handlebarsViewResolver;

        protected HandlebarsCacheConfiguration() {
        }

        @PostConstruct
        public void setCachingStrategy() {
            if (this.handlebarsViewResolver.isCache()) {
                this.handlebarsViewResolver.getHandlebars().with((TemplateCache)new GuavaTemplateCache(CacheBuilder.newBuilder().build()));
            }
        }
    }

    @Configuration
    protected static class HandlebarsViewResolverConfiguration {
        @Autowired
        private HandlebarsProperties handlebars;

        protected HandlebarsViewResolverConfiguration() {
        }

        @Bean
        public HandlebarsViewResolver handlebarsViewResolver() {
            HandlebarsViewResolver handlebarsViewResolver = new HandlebarsViewResolver();
            this.handlebars.applyToViewResolver(handlebarsViewResolver);
            return handlebarsViewResolver;
        }
    }
}

