/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http.handlers;

import java.util.Objects;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.addon.network.internal.server.http.handlers.HandlerState;
import org.zaproxy.addon.network.internal.server.http.handlers.HttpRequestHandler;
import org.zaproxy.addon.network.server.HttpMessageHandlerContext;

public class RemoveAcceptEncodingHandler
extends HttpRequestHandler {
    private static final RemoveAcceptEncodingHandler ALWAYS_ENABLED = new RemoveAcceptEncodingHandler(() -> true);
    private HandlerState status;

    public static RemoveAcceptEncodingHandler getEnabledInstance() {
        return ALWAYS_ENABLED;
    }

    public RemoveAcceptEncodingHandler(HandlerState state) {
        this.status = Objects.requireNonNull(state);
    }

    @Override
    protected void handleRequest(HttpMessageHandlerContext ctx, HttpMessage msg) {
        if (!this.status.isEnabled()) {
            return;
        }
        String encoding = msg.getRequestHeader().getHeader("Accept-Encoding");
        if (encoding == null) {
            return;
        }
        msg.getRequestHeader().setHeader("Accept-Encoding", null);
    }
}

