/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http.handlers;

import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.proxy.ArrangeableProxyListener;
import org.parosproxy.paros.core.proxy.ConnectRequestProxyListener;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.addon.network.server.HttpMessageHandler;
import org.zaproxy.addon.network.server.HttpMessageHandlerContext;
import org.zaproxy.zap.PersistentConnectionListener;
import org.zaproxy.zap.ZapGetMethod;

public class LegacyProxyListenerHandler
extends ProxyServer
implements HttpMessageHandler {
    private static final Logger LOGGER = LogManager.getLogger(LegacyProxyListenerHandler.class);
    private final List<ConnectRequestProxyListener> connectRequestProxyListeners = Collections.synchronizedList(new ArrayList());
    private final List<OverrideMessageProxyListener> overrideMessageProxyListeners = Collections.synchronizedList(new ArrayList());
    private final List<ProxyListener> proxyListeners = Collections.synchronizedList(new ArrayList());
    private final List<PersistentConnectionListener> persistentConnectionListeners = Collections.synchronizedList(new ArrayList());
    private final Comparator<ArrangeableProxyListener> listenersComparator = (o1, o2) -> Integer.compare(o1.getArrangeableListenerOrder(), o2.getArrangeableListenerOrder());

    public void addConnectRequestProxyListener(ConnectRequestProxyListener listener) {
        this.connectRequestProxyListeners.add(listener);
    }

    public void removeConnectRequestProxyListener(ConnectRequestProxyListener listener) {
        this.connectRequestProxyListeners.remove(listener);
    }

    public void addOverrideMessageProxyListener(OverrideMessageProxyListener listener) {
        this.overrideMessageProxyListeners.add(listener);
        Collections.sort(this.overrideMessageProxyListeners, this.listenersComparator);
    }

    public void removeOverrideMessageProxyListener(OverrideMessageProxyListener listener) {
        this.overrideMessageProxyListeners.remove(listener);
    }

    public void addProxyListener(ProxyListener listener) {
        this.proxyListeners.add(listener);
        Collections.sort(this.proxyListeners, this.listenersComparator);
    }

    public void removeProxyListener(ProxyListener listener) {
        this.proxyListeners.remove(listener);
    }

    public void addPersistentConnectionListener(PersistentConnectionListener listener) {
        this.persistentConnectionListeners.add(listener);
        Collections.sort(this.persistentConnectionListeners, this.listenersComparator);
    }

    public void removePersistentConnectionListener(PersistentConnectionListener listener) {
        this.persistentConnectionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(HttpMessageHandlerContext ctx, HttpMessage message) {
        if (ctx.isExcluded()) {
            return;
        }
        boolean request = ctx.isFromClient();
        if ("CONNECT".equals(message.getRequestHeader().getMethod())) {
            if (!request) {
                return;
            }
            List<ConnectRequestProxyListener> list = this.connectRequestProxyListeners;
            synchronized (list) {
                for (ConnectRequestProxyListener listener : this.connectRequestProxyListeners) {
                    LegacyProxyListenerHandler.handleErrors(() -> {
                        listener.receivedConnectRequest(message);
                        return null;
                    }, null);
                }
            }
            return;
        }
        List<OverrideMessageProxyListener> list = this.overrideMessageProxyListeners;
        synchronized (list) {
            boolean overridden = false;
            for (OverrideMessageProxyListener overrideMessageProxyListener : this.overrideMessageProxyListeners) {
                overridden = request ? LegacyProxyListenerHandler.handleErrors(() -> listener.onHttpRequestSend(message), overridden).booleanValue() : LegacyProxyListenerHandler.handleErrors(() -> listener.onHttpResponseReceived(message), overridden).booleanValue();
                if (!overridden) continue;
                ctx.overridden();
                return;
            }
        }
        list = this.proxyListeners;
        synchronized (list) {
            boolean forward = true;
            for (ProxyListener proxyListener : this.proxyListeners) {
                forward = request ? LegacyProxyListenerHandler.handleErrors(() -> proxyListener.onHttpRequestSend(message), forward).booleanValue() : LegacyProxyListenerHandler.handleErrors(() -> proxyListener.onHttpResponseReceive(message), forward).booleanValue();
                if (forward) continue;
                ctx.close();
                return;
            }
        }
    }

    private static <T> T handleErrors(Callable<T> runnable, T fallbackValue) {
        try {
            return runnable.call();
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while notifying a listener:", e);
            return fallbackValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyPersistentConnectionListener(HttpMessage message, Socket inSocket, ZapGetMethod method) {
        List<PersistentConnectionListener> list = this.persistentConnectionListeners;
        synchronized (list) {
            for (PersistentConnectionListener listener : this.persistentConnectionListeners) {
                if (!LegacyProxyListenerHandler.handleErrors(() -> listener.onHandshakeResponse(message, inSocket, method), false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

