/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http.handlers;

import java.util.Collections;
import java.util.Objects;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.addon.network.internal.server.http.handlers.HandlerState;
import org.zaproxy.addon.network.internal.server.http.handlers.HttpResponseHandler;
import org.zaproxy.addon.network.server.HttpMessageHandlerContext;
import org.zaproxy.zap.network.HttpResponseBody;

public class DecodeResponseHandler
extends HttpResponseHandler {
    private static final DecodeResponseHandler ALWAYS_ENABLED = new DecodeResponseHandler(() -> true);
    private HandlerState state;

    public static DecodeResponseHandler getEnabledInstance() {
        return ALWAYS_ENABLED;
    }

    public DecodeResponseHandler(HandlerState state) {
        this.state = Objects.requireNonNull(state);
    }

    @Override
    public void handleResponse(HttpMessageHandlerContext ctx, HttpMessage msg) {
        if (!this.state.isEnabled()) {
            return;
        }
        HttpResponseBody body = msg.getResponseBody();
        if (body.getContentEncodings().isEmpty() || body.hasContentEncodingErrors()) {
            return;
        }
        body.setBody(body.getContent());
        body.setContentEncodings(Collections.emptyList());
        HttpResponseHeader header = msg.getResponseHeader();
        header.setHeader("Content-Encoding", null);
        if (header.getHeader("Content-Length") != null) {
            header.setContentLength(body.length());
        }
    }
}

