/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http.handlers;

import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.zaproxy.addon.network.server.HttpMessageHandler;
import org.zaproxy.addon.network.server.HttpMessageHandlerContext;

public class ConnectReceivedHandler
implements HttpMessageHandler {
    private static final ConnectReceivedHandler SET_AND_OVERRIDE = new ConnectReceivedHandler(true);
    private static final ConnectReceivedHandler SET_AND_CONTINUE = new ConnectReceivedHandler(false);
    private static final String CONNECT_HTTP_200 = "HTTP/1.1 200 Connection established";
    private boolean override;

    public static ConnectReceivedHandler getSetAndOverrideInstance() {
        return SET_AND_OVERRIDE;
    }

    public static ConnectReceivedHandler getSetAndContinueInstance() {
        return SET_AND_CONTINUE;
    }

    private ConnectReceivedHandler(boolean override) {
        this.override = override;
    }

    @Override
    public void handleMessage(HttpMessageHandlerContext ctx, HttpMessage msg) {
        if (!ctx.isFromClient()) {
            return;
        }
        HttpRequestHeader request = msg.getRequestHeader();
        if (!"CONNECT".equalsIgnoreCase(request.getMethod())) {
            return;
        }
        msg.setTimeSentMillis(System.currentTimeMillis());
        try {
            msg.setResponseHeader(CONNECT_HTTP_200);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            // empty catch block
        }
        if (this.override) {
            ctx.overridden();
        }
    }
}

