/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.List;
import javax.net.ssl.KeyManager;
import org.parosproxy.paros.security.SslCertificateService;
import org.zaproxy.addon.network.internal.ChannelAttributes;
import org.zaproxy.addon.network.internal.cert.SniX509KeyManager;
import org.zaproxy.addon.network.internal.handlers.TlsConfig;

public class TlsProtocolHandler
extends ByteToMessageDecoder {
    public static final String TLS_HANDLER_NAME = "tls";
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    private final String authority;

    public TlsProtocolHandler() {
        this(null);
    }

    public TlsProtocolHandler(String authority) {
        this.authority = authority;
    }

    String getAuthority() {
        return this.authority;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 5) {
            return;
        }
        boolean upgraded = this.upgrade(ctx, in);
        ctx.channel().attr(ChannelAttributes.TLS_UPGRADED).set((Object)upgraded);
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private boolean upgrade(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (!SslHandler.isEncrypted((ByteBuf)in)) {
            return false;
        }
        Channel ch = ctx.channel();
        TlsConfig config = (TlsConfig)ch.attr(ChannelAttributes.TLS_CONFIG).get();
        SslContext sslCtx = SslContextBuilder.forServer((KeyManager)new SniX509KeyManager((SslCertificateService)ch.attr(ChannelAttributes.CERTIFICATE_SERVICE).get(), ((InetSocketAddress)ch.attr(ChannelAttributes.LOCAL_ADDRESS).get()).getAddress(), this.authority)).protocols(config.getEnabledProtocols()).build();
        ctx.pipeline().addAfter(ctx.name(), TLS_HANDLER_NAME, (ChannelHandler)sslCtx.newHandler(ctx.alloc()));
        return true;
    }
}

