/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.zaproxy.addon.network.internal.TlsUtils;

public class TlsConfig {
    private static final List<String> DEFAULT_PROTOCOLS = Arrays.asList("SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3");
    private List<String> enabledProtocols;

    public TlsConfig() {
        this.enabledProtocols = TlsUtils.filterUnsupportedProtocols(DEFAULT_PROTOCOLS);
    }

    public TlsConfig(List<String> enabledProtocols) {
        this.enabledProtocols = TlsUtils.filterUnsupportedProtocols(enabledProtocols);
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public int hashCode() {
        return Objects.hash(this.enabledProtocols);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TlsConfig)) {
            return false;
        }
        TlsConfig other = (TlsConfig)object;
        return Objects.equals(this.enabledProtocols, other.enabledProtocols);
    }
}

