/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.handlers;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.zaproxy.addon.network.internal.ChannelAttributes;
import org.zaproxy.addon.network.internal.handlers.ReadTimeoutHandler;
import org.zaproxy.addon.network.internal.handlers.ServerExceptionHandler;

public class PassthroughHandler
extends SimpleChannelInboundHandler<HttpMessage> {
    private static final Logger LOGGER = LogManager.getLogger(PassthroughHandler.class);
    private static final int CONNECT_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(20L);
    private static final int READ_TIMEOUT_MINUTES = 2;
    private final Predicate<HttpRequestHeader> passthroughCondition;

    public PassthroughHandler(Predicate<HttpRequestHeader> condition) {
        this.passthroughCondition = Objects.requireNonNull(condition);
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        if (msg.getUserObject() instanceof Exception) {
            throw (Exception)msg.getUserObject();
        }
        if (!this.isPassthrough(ctx, msg)) {
            return;
        }
        HttpRequestHeader request = msg.getRequestHeader();
        String host = request.getHostName();
        int port = request.getHostPort();
        LOGGER.debug("Passing through connection to target: {}:{}", (Object)host, (Object)port);
        ctx.channel().config().setAutoRead(false);
        while (ctx.pipeline().last() != null) {
            ctx.pipeline().remove(ctx.pipeline().last());
        }
        ctx.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(2, TimeUnit.MINUTES));
        ctx.pipeline().addLast("exception", (ChannelHandler)ExceptionHandler.getInstance());
        ctx.pipeline().addAfter("timeout", "passthrough", (ChannelHandler)new ClientSideHandler(host, port));
        ctx.fireChannelReadComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPassthrough(ChannelHandlerContext ctx, HttpMessage msg) {
        boolean passthrough = false;
        try {
            HttpRequestHeader request = msg.getRequestHeader();
            if (!"CONNECT".equals(request.getMethod())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = passthrough = this.passthroughCondition.test(request);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while checking if passthrough request:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            ctx.channel().attr(ChannelAttributes.PASSTHROUGH).set((Object)passthrough);
            ctx.fireChannelRead((Object)msg);
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static class ExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private static final ExceptionHandler INSTANCE = new ExceptionHandler();

        private ExceptionHandler() {
        }

        public static ExceptionHandler getInstance() {
            return INSTANCE;
        }

        public boolean isSharable() {
            return true;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof ChannelPipelineException) {
                LOGGER.warn("Failed while connecting to passthrough to target: {}", (Object)cause.getCause().getMessage());
                ctx.close();
                return;
            }
            ServerExceptionHandler.getInstance().exceptionCaught(ctx, cause);
        }
    }

    private static class ServerSideHandler
    extends ChannelInboundHandlerAdapter {
        private static final Logger LOGGER = LogManager.getLogger(ServerSideHandler.class);
        private final Channel inboundChannel;

        public ServerSideHandler(Channel inboundChannel) {
            this.inboundChannel = inboundChannel;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.read();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.inboundChannel.writeAndFlush(msg).addListener(future -> {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    future.channel().close();
                }
            });
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            LOGGER.debug("Server side is inactive, closing.");
            PassthroughHandler.closeOnFlush(this.inboundChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof ReadTimeoutException) {
                LOGGER.debug("Timed out while reading from server.");
            } else {
                LOGGER.debug("Exception while handling server side.", cause);
            }
            PassthroughHandler.closeOnFlush(ctx.channel());
        }
    }

    private static class ClientSideHandler
    extends ChannelInboundHandlerAdapter {
        private static final Logger LOGGER = LogManager.getLogger(ClientSideHandler.class);
        private final String host;
        private final int port;
        private Channel outboundChannel;

        public ClientSideHandler(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            Channel inboundChannel = ctx.channel();
            ChannelFuture f = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)inboundChannel.eventLoop())).channel(ctx.channel().getClass())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)CONNECT_TIMEOUT_MILLIS)).handler((ChannelHandler)new ServerSideHandler(inboundChannel))).option(ChannelOption.AUTO_READ, (Object)false)).connect(this.host, this.port);
            this.outboundChannel = f.channel();
            this.outboundChannel.pipeline().addFirst(new ChannelHandler[]{new ReadTimeoutHandler(2, TimeUnit.MINUTES)});
            f.addListener(future -> {
                if (future.isSuccess()) {
                    LOGGER.debug("Connected to: {}:{}", (Object)this.host, (Object)this.port);
                    inboundChannel.read();
                } else {
                    LOGGER.warn("Failed to connect to target: {}:{}", (Object)this.host, (Object)this.port, (Object)future.cause());
                    inboundChannel.close();
                }
            });
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (this.outboundChannel.isActive()) {
                this.outboundChannel.writeAndFlush(msg).addListener(future -> {
                    if (future.isSuccess()) {
                        ctx.channel().read();
                    } else {
                        future.channel().close();
                    }
                });
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            LOGGER.debug("Client side is inactive, closing.");
            if (this.outboundChannel != null) {
                PassthroughHandler.closeOnFlush(this.outboundChannel);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof ReadTimeoutException) {
                LOGGER.debug("Timed out while reading from client.");
            } else {
                LOGGER.debug("Exception while handling client side.", cause);
            }
            PassthroughHandler.closeOnFlush(ctx.channel());
        }
    }
}

