/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMessage;

@ChannelHandler.Sharable
abstract class HttpMessageEncoder
extends MessageToByteEncoder<HttpMessage> {
    private static final int CRLF = 3338;
    private final Function<HttpMessage, HttpHeader> headerProvider;
    private final Function<HttpMessage, HttpBody> bodyProvider;

    HttpMessageEncoder(Function<HttpMessage, HttpHeader> headerProvider, Function<HttpMessage, HttpBody> bodyProvider) {
        super(HttpMessage.class);
        this.headerProvider = headerProvider;
        this.bodyProvider = bodyProvider;
    }

    public boolean isSharable() {
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, HttpMessage msg, ByteBuf out) {
        HttpHeader header = this.headerProvider.apply(msg);
        out.writeCharSequence((CharSequence)header.getPrimeHeader(), StandardCharsets.US_ASCII);
        ByteBufUtil.writeShortBE((ByteBuf)out, (int)3338);
        out.writeCharSequence((CharSequence)header.getHeadersAsString(), StandardCharsets.US_ASCII);
        ByteBufUtil.writeShortBE((ByteBuf)out, (int)3338);
        HttpBody body = this.bodyProvider.apply(msg);
        if (body.length() != 0) {
            out.writeBytes(body.getBytes());
        }
    }
}

