/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.cert;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.parosproxy.paros.security.CertData;
import org.zaproxy.addon.network.ServerCertificatesOptions;
import org.zaproxy.addon.network.internal.cert.CertificateUtils;

public class ServerCertificateGenerator {
    private static final AtomicLong serial;
    private final X509Certificate rootCaCert;
    private final PublicKey rootCaPublicKey;
    private final PrivateKey rooCaPrivateKey;
    private final ServerCertificatesOptions serverCertificatesOptions;
    private final Map<CertData, KeyStore> cache;

    public ServerCertificateGenerator(KeyStore keyStore, ServerCertificatesOptions serverCertificatesOptions) {
        Objects.requireNonNull(keyStore);
        this.serverCertificatesOptions = Objects.requireNonNull(serverCertificatesOptions);
        this.rootCaCert = Objects.requireNonNull(CertificateUtils.getCertificate(keyStore));
        this.rootCaPublicKey = this.rootCaCert.getPublicKey();
        this.rooCaPrivateKey = Objects.requireNonNull(CertificateUtils.getPrivateKey(keyStore));
        this.cache = new HashMap<CertData, KeyStore>();
    }

    public synchronized KeyStore generate(CertData certData) {
        Objects.requireNonNull(certData);
        return this.cache.computeIfAbsent(certData, data -> CertificateUtils.createServerKeyStore(this.rootCaCert, this.rootCaPublicKey, this.rooCaPrivateKey, data, serial.getAndIncrement(), this.serverCertificatesOptions.getServerCertConfig()));
    }

    static {
        Random rnd = new Random();
        rnd.setSeed(System.currentTimeMillis());
        long sl = (long)rnd.nextInt() << 32 | (long)rnd.nextInt() & 0xFFFFFFFFL;
        serial = new AtomicLong(sl &= 0xFFFFFFFFFFFFL);
    }
}

