/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network;

import java.io.IOException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.addon.network.internal.cert.CertConfig;
import org.zaproxy.addon.network.internal.cert.CertificateUtils;
import org.zaproxy.zap.common.VersionedAbstractParam;

public class ServerCertificatesOptions
extends VersionedAbstractParam {
    private static final Logger LOGGER = LogManager.getLogger(ServerCertificatesOptions.class);
    public static final int DEFAULT_ROOT_CA_CERT_VALIDITY = 365;
    public static final int DEFAULT_SERVER_CERT_VALIDITY = 368;
    private static final int CURRENT_CONFIG_VERSION = 1;
    private static final String BASE_KEY = "network.serverCertificates";
    private static final String CONFIG_VERSION_KEY = "network.serverCertificates[@version]";
    private static final String ROOT_CA_BASE_KEY = "network.serverCertificates.rootCa.";
    public static final String ROOT_CA_KEY_STORE = "network.serverCertificates.rootCa.ks";
    private static final String ROOT_CA_CERT_VALIDITY_DAYS = "network.serverCertificates.rootCa.certValidityDays";
    private static final String SERVER_BASE_KEY = "network.serverCertificates.server.";
    private static final String SERVER_CERT_VALIDITY_DAYS = "network.serverCertificates.server.certValidityDays";
    private KeyStore rootCaKeyStore;
    private Duration rootCaCertValidity = Duration.ofDays(365L);
    private CertConfig rootCaCertConfig = new CertConfig(this.rootCaCertValidity);
    private Duration serverCertValidity = Duration.ofDays(368L);
    private CertConfig serverCertConfig = new CertConfig(this.serverCertValidity);

    protected int getCurrentVersion() {
        return 1;
    }

    protected String getConfigVersionKey() {
        return CONFIG_VERSION_KEY;
    }

    protected void parseImpl() {
        this.migrateCoreConfig();
        this.rootCaKeyStore = this.createKeyStore(this.getString(ROOT_CA_KEY_STORE, null));
        int validity = this.getInt(ROOT_CA_CERT_VALIDITY_DAYS, 365);
        if (ServerCertificatesOptions.isInvalidCertValidity(validity)) {
            validity = 365;
        }
        this.rootCaCertValidity = Duration.ofDays(validity);
        this.rootCaCertConfig = new CertConfig(this.rootCaCertValidity);
        validity = this.getInt(SERVER_CERT_VALIDITY_DAYS, 368);
        if (ServerCertificatesOptions.isInvalidCertValidity(validity)) {
            validity = 368;
        }
        this.serverCertValidity = Duration.ofDays(validity);
        this.serverCertConfig = new CertConfig(this.serverCertValidity);
    }

    private void migrateCoreConfig() {
        String oldConfig = "dynssl.param.rootca";
        String value = this.getString(oldConfig, "");
        if (!value.isEmpty()) {
            this.getConfig().setProperty(ROOT_CA_KEY_STORE, (Object)value);
        }
        this.getConfig().clearProperty(oldConfig);
    }

    private static boolean isInvalidCertValidity(Number validity) {
        return validity.intValue() <= 0;
    }

    private KeyStore createKeyStore(String value) {
        if (value == null || value.isEmpty()) {
            return this.rootCaKeyStore;
        }
        try {
            return CertificateUtils.stringToKeystore(value);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while converting from string:", (Throwable)e);
            return null;
        }
    }

    protected void updateConfigsImpl(int fileVersion) {
    }

    public KeyStore getRootCaKeyStore() {
        return this.rootCaKeyStore;
    }

    public void setRootCaKeyStore(KeyStore keyStore) {
        String rootCaCertString;
        Objects.requireNonNull(keyStore);
        try {
            rootCaCertString = CertificateUtils.keyStoreToString(keyStore);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while converting to string:", (Throwable)e);
            return;
        }
        this.getConfig().setProperty(ROOT_CA_KEY_STORE, (Object)rootCaCertString);
        this.rootCaKeyStore = keyStore;
    }

    public Duration getRootCaCertValidity() {
        return this.rootCaCertValidity;
    }

    public void setRootCaCertValidity(Duration validity) {
        long days = Objects.requireNonNull(validity).toDays();
        if (ServerCertificatesOptions.isInvalidCertValidity(days)) {
            throw new IllegalArgumentException("The validity must be greater than 1 day.");
        }
        this.getConfig().setProperty(ROOT_CA_CERT_VALIDITY_DAYS, (Object)days);
        this.rootCaCertValidity = validity;
        this.rootCaCertConfig = new CertConfig(this.rootCaCertValidity);
    }

    public CertConfig getRootCaCertConfig() {
        return this.rootCaCertConfig;
    }

    public Duration getServerCertValidity() {
        return this.serverCertValidity;
    }

    public void setServerCertValidity(Duration validity) {
        long days = Objects.requireNonNull(validity).toDays();
        if (ServerCertificatesOptions.isInvalidCertValidity(days)) {
            throw new IllegalArgumentException("The validity must be greater than 1 day.");
        }
        this.getConfig().setProperty(SERVER_CERT_VALIDITY_DAYS, (Object)days);
        this.serverCertValidity = validity;
        this.serverCertConfig = new CertConfig(this.serverCertValidity);
    }

    public CertConfig getServerCertConfig() {
        return this.serverCertConfig;
    }
}

