/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.webflux.advice.http;

import java.util.Set;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ServerWebExchange;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.spring.webflux.advice.AdviceTrait;
import reactor.core.publisher.Mono;

@API(status=API.Status.STABLE)
public interface MethodNotAllowedAdviceTrait
extends AdviceTrait {
    @API(status=API.Status.INTERNAL)
    @ExceptionHandler
    default public Mono<ResponseEntity<Problem>> handleRequestMethodNotSupportedException(MethodNotAllowedException exception, ServerWebExchange request) {
        Set methods = exception.getSupportedMethods();
        if (methods.isEmpty()) {
            return this.create((StatusType)Status.METHOD_NOT_ALLOWED, (Throwable)exception, request);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(methods);
        return this.create((StatusType)Status.METHOD_NOT_ALLOWED, (Throwable)exception, request, headers);
    }
}

