/*
 * Decompiled with CFR 0.152.
 */
package org.yamj.api.common.http;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.http.DigestedResponse;
import org.yamj.api.common.http.HttpClientWrapper;

public class PoolingHttpClient
extends HttpClientWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(PoolingHttpClient.class);
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final PoolingHttpClientConnectionManager connManager;
    private final Map<String, Integer> groupLimits;
    private final List<String> routedHosts;

    public PoolingHttpClient(HttpClient httpClient, PoolingHttpClientConnectionManager connManager) {
        super(httpClient);
        this.connManager = connManager;
        this.groupLimits = new HashMap<String, Integer>();
        this.routedHosts = new ArrayList<String>();
    }

    public Charset getDefaultCharset() {
        return UTF8_CHARSET;
    }

    public void addGroupLimit(String group, Integer limit) {
        this.groupLimits.put(group, limit);
    }

    @Override
    protected void prepareRequest(HttpUriRequest request) throws ClientProtocolException {
        this.prepareRequest(PoolingHttpClient.determineTarget(request), (HttpRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareRequest(HttpHost target, HttpRequest request) throws ClientProtocolException {
        super.prepareRequest(target, request);
        String key = target.toString();
        List<String> list = this.routedHosts;
        synchronized (list) {
            if (!this.routedHosts.contains(key)) {
                String group = ".*";
                for (String searchGroup : this.groupLimits.keySet()) {
                    if (!key.matches(searchGroup) || searchGroup.length() <= group.length()) continue;
                    group = searchGroup;
                }
                int maxRequests = this.groupLimits.get(group);
                LOG.debug("IO download host: {}; rule: {}, maxRequests: {}", new Object[]{key, group, maxRequests});
                this.routedHosts.add(key);
                HttpRoute httpRoute = new HttpRoute(target);
                this.connManager.setMaxPerRoute(httpRoute, maxRequests);
            }
        }
    }

    @Override
    public DigestedResponse requestContent(HttpGet httpGet, Charset charset) throws IOException {
        return super.requestContent(httpGet, charset == null ? this.getDefaultCharset() : charset);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.connManager.close();
    }
}

