/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.Stack;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.XHTMLParser;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiReference;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.reference.link.URILabelGenerator;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.xhtml.handler.CommentHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.XhtmlHandler;
import org.xwiki.xml.XMLUtils;

public class XWikiCommentHandler
extends CommentHandler {
    private XHTMLParser parser;
    private PrintRendererFactory xwikiSyntaxPrintRendererFactory;
    private ComponentManager componentManager;
    private ResourceReferenceParser xhtmlMarkerResourceReferenceParser;
    private Stack<String> commentContentStack = new Stack();

    public XWikiCommentHandler(ComponentManager componentManager, XHTMLParser parser, PrintRendererFactory xwikiSyntaxPrintRendererFactory, ResourceReferenceParser xhtmlMarkerResourceReferenceParser) {
        this.componentManager = componentManager;
        this.parser = parser;
        this.xwikiSyntaxPrintRendererFactory = xwikiSyntaxPrintRendererFactory;
        this.xhtmlMarkerResourceReferenceParser = xhtmlMarkerResourceReferenceParser;
    }

    public void onComment(String content, XhtmlHandler.TagStack stack) {
        boolean ignoreElements = (Boolean)stack.getStackParameter("ignoreElements");
        if (!ignoreElements && content.startsWith("startwikilink:")) {
            this.handleLinkCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("stopwikilink")) {
            this.handleLinkCommentStop(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("startimage:")) {
            this.handleImageCommentStart(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("stopimage")) {
            this.handleImageCommentStop(XMLUtils.unescapeXMLComment((String)content), stack);
        } else if (!ignoreElements && content.startsWith("startmacro")) {
            super.onComment(XMLUtils.unescapeXMLComment((String)content), stack);
        } else {
            super.onComment(content, stack);
        }
    }

    private void handleLinkCommentStart(String content, XhtmlHandler.TagStack stack) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        PrintRenderer linkLabelRenderer = this.xwikiSyntaxPrintRendererFactory.createRenderer((WikiPrinter)printer);
        linkLabelRenderer.beginDocument(MetaData.EMPTY);
        XWikiGeneratorListener xwikiListener = this.parser.createXWikiGeneratorListener((Listener)linkLabelRenderer, null);
        stack.pushStackParameter("linkListener", (Object)xwikiListener);
        stack.pushStackParameter("isInLink", (Object)true);
        stack.pushStackParameter("isFreeStandingLink", (Object)false);
        stack.pushStackParameter("linkParameters", (Object)WikiParameters.EMPTY);
        this.commentContentStack.push(content.substring("startwikilink:".length()));
    }

    private void handleLinkCommentStop(String content, XhtmlHandler.TagStack stack) {
        XWikiGeneratorListener xwikiListener = (XWikiGeneratorListener)stack.popStackParameter("linkListener");
        PrintRenderer linkLabelRenderer = (PrintRenderer)xwikiListener.getListener();
        linkLabelRenderer.endDocument(MetaData.EMPTY);
        boolean isFreeStandingLink = (Boolean)stack.getStackParameter("isFreeStandingLink");
        ResourceReference linkReference = this.xhtmlMarkerResourceReferenceParser.parse(this.commentContentStack.pop());
        WikiParameters linkParams = WikiParameters.EMPTY;
        String label = null;
        if (!isFreeStandingLink) {
            label = linkLabelRenderer.getPrinter().toString();
            linkParams = (WikiParameters)stack.getStackParameter("linkParameters");
        }
        XWikiWikiReference wikiReference = new XWikiWikiReference(linkReference, label, linkParams, isFreeStandingLink);
        stack.getScannerContext().onReference((WikiReference)wikiReference);
        stack.popStackParameter("isInLink");
        stack.popStackParameter("isFreeStandingLink");
        stack.popStackParameter("linkParameters");
    }

    private void handleImageCommentStart(String content, XhtmlHandler.TagStack stack) {
        stack.setStackParameter("isInImage", (Object)true);
        this.commentContentStack.push(content.substring("startimage:".length()));
    }

    private void handleImageCommentStop(String content, XhtmlHandler.TagStack stack) {
        WikiParameter alt;
        boolean isFreeStandingImage = (Boolean)stack.getStackParameter("isFreeStandingImage");
        ResourceReference imageReference = this.xhtmlMarkerResourceReferenceParser.parse(this.commentContentStack.pop());
        WikiParameters imageParams = WikiParameters.EMPTY;
        if (!isFreeStandingImage && (alt = (imageParams = (WikiParameters)stack.getStackParameter("imageParameters")).getParameter("alt")) != null && alt.getValue().equals(this.computeAltAttributeValue(imageReference))) {
            imageParams = imageParams.remove("alt");
        }
        XWikiWikiReference reference = new XWikiWikiReference(imageReference, null, imageParams, isFreeStandingImage);
        stack.getScannerContext().onImage((WikiReference)reference);
        stack.setStackParameter("isInImage", (Object)false);
        stack.setStackParameter("isFreeStandingImage", (Object)false);
        stack.setStackParameter("imageParameters", (Object)WikiParameters.EMPTY);
    }

    private String computeAltAttributeValue(ResourceReference reference) {
        String label;
        try {
            URILabelGenerator uriLabelGenerator = (URILabelGenerator)this.componentManager.getInstance(URILabelGenerator.class, reference.getType().getScheme());
            label = uriLabelGenerator.generateLabel(reference);
        }
        catch (ComponentLookupException e) {
            label = reference.getReference();
        }
        return label;
    }
}

