/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.image;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageTypeRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.rendering.renderer.reference.link.URILabelGenerator;

public abstract class AbstractXHTMLImageTypeRenderer
implements XHTMLImageTypeRenderer {
    protected static final String CLASS = "class";
    protected static final String ID = "id";
    protected static final String SPAN = "span";
    protected static final String TT = "tt";
    @Inject
    protected ComponentManager componentManager;
    private XHTMLWikiPrinter xhtmlPrinter;

    @Override
    public void setXHTMLWikiPrinter(XHTMLWikiPrinter printer) {
        this.xhtmlPrinter = printer;
    }

    @Override
    public XHTMLWikiPrinter getXHTMLWikiPrinter() {
        return this.xhtmlPrinter;
    }

    public void onImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.onImage(reference, freestanding, null, parameters);
    }

    public void onImage(ResourceReference reference, boolean freestanding, String id, Map<String, String> parameters) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        try {
            String imageSrcAttributeValue = this.getImageSrcAttributeValue(reference, parameters);
            attributes.put("src", imageSrcAttributeValue);
            if (freestanding) {
                attributes.put(CLASS, "wikimodel-freestanding");
            }
            attributes.putAll(parameters);
            if (StringUtils.isNotBlank((CharSequence)id) && !attributes.containsKey(ID)) {
                attributes.put(ID, id);
                attributes.computeIfPresent(CLASS, (key, value) -> value.trim() + " wikigeneratedid");
                attributes.putIfAbsent(CLASS, "wikigeneratedid");
            }
            if (!parameters.containsKey("alt")) {
                attributes.put("alt", this.computeAltAttributeValue(reference));
            }
            this.getXHTMLWikiPrinter().printXMLElement("img", attributes);
        }
        catch (Throwable e) {
            this.getXHTMLWikiPrinter().printXMLStartElement(SPAN, (String[][])new String[][]{{CLASS, "xwikirenderingerror"}});
            this.getXHTMLWikiPrinter().printXML(e.getMessage());
            this.getXHTMLWikiPrinter().printXMLEndElement(SPAN);
            this.getXHTMLWikiPrinter().printXMLStartElement(SPAN, (String[][])new String[][]{{CLASS, "xwikirenderingerrordescription hidden"}});
            this.getXHTMLWikiPrinter().printXMLStartElement(TT, (String[][])new String[][]{{CLASS, "wikimodel-verbatim"}});
            this.getXHTMLWikiPrinter().printXML(ExceptionUtils.getStackTrace((Throwable)e));
            this.getXHTMLWikiPrinter().printXMLEndElement(TT);
            this.getXHTMLWikiPrinter().printXMLEndElement(SPAN);
        }
    }

    protected abstract String getImageSrcAttributeValue(ResourceReference var1, Map<String, String> var2);

    private String computeAltAttributeValue(ResourceReference reference) {
        String label;
        try {
            URILabelGenerator uriLabelGenerator = (URILabelGenerator)this.componentManager.getInstance(URILabelGenerator.class, reference.getType().getScheme());
            label = uriLabelGenerator.generateLabel(reference);
        }
        catch (ComponentLookupException e) {
            label = reference.getReference();
        }
        return label;
    }
}

