/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.lang.reflect.Type;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.XHTMLParser;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.InlineFilterListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XHTMLXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiModelHandler;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.WrappingListener;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.impl.WikiScannerContext;
import org.xwiki.rendering.wikimodel.xhtml.impl.MacroInfo;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;

public class XWikiMacroHandler
implements XWikiWikiModelHandler {
    private static final String WIKI_CONTENT_TYPE = ReflectionUtils.serializeType((Type)Block.LIST_BLOCK_TYPE);
    private ComponentManager componentManager;
    private XHTMLParser parser;
    @Inject
    private Logger logger;

    public XWikiMacroHandler(ComponentManager componentManager, XHTMLParser parser) {
        this.componentManager = componentManager;
        this.parser = parser;
    }

    private String getSyntax(TagContext previousNodes, String macroType) {
        if (!macroType.equals(WIKI_CONTENT_TYPE)) {
            return Syntax.PLAIN_1_0.toIdString();
        }
        if (previousNodes.getTagStack().getStackParameter("currentSyntax") != null) {
            return (String)previousNodes.getTagStack().popStackParameter("currentSyntax");
        }
        Syntax syntax = null;
        try {
            RenderingContext renderingContext = (RenderingContext)this.componentManager.getInstance(RenderingContext.class);
            syntax = renderingContext.getTargetSyntax();
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error while retrieving the rendering context", (Throwable)e);
        }
        if (syntax == null) {
            syntax = this.parser.getSyntax();
        }
        return syntax.toIdString();
    }

    private XWikiGeneratorListener createMacroListener(TagContext context, String currentSyntaxParameter) throws ComponentLookupException {
        Object listener;
        PrintRenderer renderer = (PrintRenderer)this.componentManager.getInstance(PrintRenderer.class, currentSyntaxParameter);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        renderer.setPrinter((WikiPrinter)printer);
        if (context.getTagStack().isInsideBlockElement()) {
            listener = new InlineFilterListener();
            ((InlineFilterListener)((Object)listener)).setWrappedListener((Listener)renderer);
        } else {
            listener = renderer;
        }
        return this.parser.createXWikiGeneratorListener((Listener)listener, null);
    }

    public boolean handleBegin(TagContext context) {
        WikiParameters params = context.getParams();
        MacroInfo macroInfo = (MacroInfo)context.getTagStack().getStackParameter("macroInfo");
        boolean withNonGeneratedContent = false;
        if (XHTMLXWikiGeneratorListener.isMetaDataElement(params)) {
            MetaData metaData = XHTMLXWikiGeneratorListener.createMetaData(params);
            if (metaData.contains("syntax")) {
                String currentSyntax = (String)metaData.getMetaData("syntax");
                context.getTagStack().pushStackParameter("currentSyntax", (Object)currentSyntax);
            }
            if (metaData.contains("non-generated-content")) {
                String currentSyntaxParameter = this.getSyntax(context, (String)metaData.getMetaData("non-generated-content"));
                try {
                    String parameterName = (String)metaData.getMetaData("parameter-name");
                    withNonGeneratedContent = true;
                    if (parameterName != null && macroInfo.getParameterScannerContext(parameterName) == null) {
                        context.getTagStack().pushStackParameter("parameterContentName", (Object)parameterName);
                        context.getTagStack().pushScannerContext(new WikiScannerContext((IWemListener)this.createMacroListener(context, currentSyntaxParameter)));
                        context.getTagStack().getScannerContext().beginDocument();
                        macroInfo.setParameterScannerContext(parameterName, context.getScannerContext());
                    } else if (parameterName == null && macroInfo.getContentScannerContext() == null) {
                        context.getTagStack().pushScannerContext(new WikiScannerContext((IWemListener)this.createMacroListener(context, currentSyntaxParameter)));
                        macroInfo.setContentScannerContext(context.getTagStack().getScannerContext());
                        context.getTagStack().resetEmptyLinesCount();
                        context.getTagStack().getScannerContext().beginDocument();
                    }
                }
                catch (ComponentLookupException e) {
                    this.logger.error("Error while getting the appropriate renderer for syntax [{}]", (Object)currentSyntaxParameter, (Object)e);
                }
            }
        }
        context.getTagStack().pushStackParameter("nonGeneratedContentStack", (Object)withNonGeneratedContent);
        return withNonGeneratedContent;
    }

    private String getRenderedContentFromMacro(TagContext context) {
        PrintRenderer renderer;
        context.getTagStack().getScannerContext().endDocument();
        XWikiGeneratorListener xWikiGeneratorListener = (XWikiGeneratorListener)context.getTagStack().popScannerContext().getfListener();
        if (context.getTagStack().isInsideBlockElement() && xWikiGeneratorListener.getListener() instanceof WrappingListener) {
            WrappingListener wrappingListener = (WrappingListener)xWikiGeneratorListener.getListener();
            renderer = (PrintRenderer)wrappingListener.getWrappedListener();
        } else {
            renderer = (PrintRenderer)xWikiGeneratorListener.getListener();
        }
        return renderer.getPrinter().toString();
    }

    public boolean handleEnd(TagContext context) {
        boolean nonGeneratedContent = (Boolean)context.getTagStack().popStackParameter("nonGeneratedContentStack");
        MacroInfo macroInfo = (MacroInfo)context.getTagStack().getStackParameter("macroInfo");
        if (nonGeneratedContent && macroInfo != null) {
            String parameterName = (String)context.getTagStack().getStackParameter("parameterContentName");
            if (parameterName != null && macroInfo.getParameterScannerContext(parameterName) != null) {
                context.getTagStack().popStackParameter("parameterContentName");
                WikiParameters parameters = macroInfo.getParameters();
                macroInfo.setParameters(parameters.setParameter(parameterName, this.getRenderedContentFromMacro(context)));
                macroInfo.setParameterScannerContext(parameterName, null);
            } else if (macroInfo.getContentScannerContext() != null && (parameterName == null || macroInfo.getParameters().getParameter(parameterName) == null)) {
                macroInfo.setContent(this.getRenderedContentFromMacro(context));
                macroInfo.setContentScannerContext(null);
            }
        }
        return nonGeneratedContent;
    }
}

