/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.rendering.internal.renderer.AbstractPrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;

@Component(hints={"xhtmlmacro/1.0", "htmlmacro+annotatedxhtml/1.0", "htmlmacro+annotatedhtml/5.0", "htmlmacro+html/5.0"})
@Singleton
public class HTMLMacroXHTMLRendererFactory
extends AbstractPrintRendererFactory {
    public static final String PREFIX_SYNTAX = "htmlmacro+";
    private static final Syntax XHTML_SYNTAX = new Syntax(new SyntaxType("xhtmlmacro", "XHTML Macro"), "1.0");
    private static final List<Syntax> SUPPORTED_SYNTAXES = Arrays.asList(Syntax.ANNOTATED_XHTML_1_0, Syntax.ANNOTATED_HTML_5_0, Syntax.HTML_5_0);
    private final List<Syntax> htmlMacroSyntaxes = new ArrayList<Syntax>();
    @Inject
    private ComponentDescriptor componentDescriptor;

    public HTMLMacroXHTMLRendererFactory() {
        for (Syntax existedAcceptedSyntax : SUPPORTED_SYNTAXES) {
            SyntaxType type = existedAcceptedSyntax.getType();
            this.htmlMacroSyntaxes.add(new Syntax(new SyntaxType(PREFIX_SYNTAX + type.getId(), "HTML Macro " + type.getName()), existedAcceptedSyntax.getVersion()));
        }
    }

    public Syntax getSyntax() {
        Syntax result = XHTML_SYNTAX;
        String roleHint = this.componentDescriptor.getRoleHint();
        for (Syntax acceptedSyntax : this.htmlMacroSyntaxes) {
            if (!roleHint.equals(acceptedSyntax.toIdString())) continue;
            result = acceptedSyntax;
        }
        return result;
    }
}

