/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.util;

import java.util.List;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Role;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogUtils;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.rendering.block.Block;
import org.xwiki.stability.Unstable;

@Role
public interface ErrorBlockGenerator {
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    public static final String CLASS_ATTRIBUTE_MESSAGE_VALUE = "xwikirenderingerror";
    public static final String CLASS_ATTRIBUTE_DESCRIPTION_VALUE = "xwikirenderingerrordescription hidden";

    @Unstable
    default public boolean containsError(Block block) {
        return false;
    }

    @Deprecated
    public List<Block> generateErrorBlocks(String var1, String var2, boolean var3);

    @Deprecated
    public List<Block> generateErrorBlocks(String var1, Throwable var2, boolean var3);

    @Unstable
    default public List<Block> generateErrorBlocks(boolean inline, String messageId, String defaultMessage, String defaultDescription, Object ... arguments) {
        TranslationMarker marker = new TranslationMarker(messageId);
        LogEvent message = LogUtils.newLogEvent((Marker)marker, (LogLevel)LogLevel.ERROR, (String)defaultMessage, (Object[])arguments);
        if (message.getThrowable() != null) {
            return this.generateErrorBlocks(message.getFormattedMessage(), message.getThrowable(), inline);
        }
        LogEvent description = LogUtils.newLogEvent((Marker)marker, (LogLevel)LogLevel.ERROR, (String)defaultDescription, (Object[])arguments);
        return this.generateErrorBlocks(message.getFormattedMessage(), description.getFormattedMessage(), inline);
    }
}

