/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.listener.chaining;

import java.util.Map;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.syntax.Syntax;

public enum EventType {
    BEGIN_DOCUMENT{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginDocument((MetaData)eventParameters[0]);
        }
    }
    ,
    END_DOCUMENT{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endDocument((MetaData)eventParameters[0]);
        }
    }
    ,
    BEGIN_GROUP{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginGroup((Map)eventParameters[0]);
        }
    }
    ,
    END_GROUP{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endGroup((Map)eventParameters[0]);
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    BEGIN_PARAGRAPH{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginParagraph((Map)eventParameters[0]);
        }
    }
    ,
    END_PARAGRAPH{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endParagraph((Map)eventParameters[0]);
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    BEGIN_DEFINITION_LIST{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginDefinitionList((Map)eventParameters[0]);
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    END_DEFINITION_LIST{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endDefinitionList((Map)eventParameters[0]);
        }
    }
    ,
    BEGIN_DEFINITION_TERM{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginDefinitionTerm();
        }
    }
    ,
    END_DEFINITION_TERM{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endDefinitionTerm();
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    BEGIN_DEFINITION_DESCRIPTION{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginDefinitionDescription();
        }
    }
    ,
    END_DEFINITION_DESCRIPTION{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endDefinitionDescription();
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    BEGIN_FORMAT{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginFormat((Format)((Object)eventParameters[0]), (Map)eventParameters[1]);
        }
    }
    ,
    END_FORMAT{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endFormat((Format)((Object)eventParameters[0]), (Map)eventParameters[1]);
        }
    }
    ,
    BEGIN_HEADER{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginHeader((HeaderLevel)((Object)eventParameters[0]), (String)eventParameters[1], (Map)eventParameters[2]);
        }
    }
    ,
    END_HEADER{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endHeader((HeaderLevel)((Object)eventParameters[0]), (String)eventParameters[1], (Map)eventParameters[2]);
        }
    }
    ,
    BEGIN_LINK{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginLink((ResourceReference)eventParameters[0], (Boolean)eventParameters[1], (Map)eventParameters[2]);
        }
    }
    ,
    END_LINK{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endLink((ResourceReference)eventParameters[0], (Boolean)eventParameters[1], (Map)eventParameters[2]);
        }
    }
    ,
    BEGIN_LIST{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginList((ListType)((Object)eventParameters[0]), (Map)eventParameters[1]);
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    END_LIST{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endList((ListType)((Object)eventParameters[0]), (Map)eventParameters[1]);
        }
    }
    ,
    BEGIN_LIST_ITEM{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            if (eventParameters.length > 0) {
                listener.beginListItem((Map)eventParameters[0]);
            } else {
                listener.beginListItem();
            }
        }
    }
    ,
    END_LIST_ITEM{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            if (eventParameters.length > 0) {
                listener.endListItem((Map)eventParameters[0]);
            } else {
                listener.endListItem();
            }
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    BEGIN_MACRO_MARKER{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginMacroMarker((String)eventParameters[0], (Map)eventParameters[1], (String)eventParameters[2], (Boolean)eventParameters[3]);
        }
    }
    ,
    END_MACRO_MARKER{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endMacroMarker((String)eventParameters[0], (Map)eventParameters[1], (String)eventParameters[2], (Boolean)eventParameters[3]);
        }
    }
    ,
    BEGIN_QUOTATION{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginQuotation((Map)eventParameters[0]);
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    END_QUOTATION{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endQuotation((Map)eventParameters[0]);
        }
    }
    ,
    BEGIN_QUOTATION_LINE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginQuotationLine();
        }
    }
    ,
    END_QUOTATION_LINE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endQuotationLine();
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    BEGIN_SECTION{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginSection((Map)eventParameters[0]);
        }
    }
    ,
    END_SECTION{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endSection((Map)eventParameters[0]);
        }
    }
    ,
    BEGIN_TABLE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginTable((Map)eventParameters[0]);
        }
    }
    ,
    END_TABLE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endTable((Map)eventParameters[0]);
        }
    }
    ,
    BEGIN_TABLE_CELL{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginTableCell((Map)eventParameters[0]);
        }
    }
    ,
    END_TABLE_CELL{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endTableCell((Map)eventParameters[0]);
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    BEGIN_TABLE_HEAD_CELL{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginTableHeadCell((Map)eventParameters[0]);
        }
    }
    ,
    END_TABLE_HEAD_CELL{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endTableHeadCell((Map)eventParameters[0]);
        }

        @Override
        public boolean isInlineEnd() {
            return true;
        }
    }
    ,
    BEGIN_TABLE_ROW{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginTableRow((Map)eventParameters[0]);
        }
    }
    ,
    END_TABLE_ROW{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endTableRow((Map)eventParameters[0]);
        }
    }
    ,
    BEGIN_METADATA{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginMetaData((MetaData)eventParameters[0]);
        }
    }
    ,
    END_METADATA{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endMetaData((MetaData)eventParameters[0]);
        }
    }
    ,
    ON_RAW_TEXT{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onRawText((String)eventParameters[0], (Syntax)eventParameters[1]);
        }
    }
    ,
    ON_EMPTY_LINES{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onEmptyLines((Integer)eventParameters[0]);
        }
    }
    ,
    ON_HORIZONTAL_LINE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onHorizontalLine((Map)eventParameters[0]);
        }
    }
    ,
    ON_ID{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onId((String)eventParameters[0]);
        }
    }
    ,
    ON_IMAGE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            if (eventParameters.length == 4) {
                listener.onImage((ResourceReference)eventParameters[0], (Boolean)eventParameters[1], (String)eventParameters[2], (Map)eventParameters[3]);
            } else {
                listener.onImage((ResourceReference)eventParameters[0], (Boolean)eventParameters[1], (Map)eventParameters[2]);
            }
        }
    }
    ,
    ON_MACRO{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onMacro((String)eventParameters[0], (Map)eventParameters[1], (String)eventParameters[2], (Boolean)eventParameters[3]);
        }
    }
    ,
    ON_NEW_LINE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onNewLine();
        }
    }
    ,
    ON_SPACE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onSpace();
        }
    }
    ,
    ON_SPECIAL_SYMBOL{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onSpecialSymbol(((Character)eventParameters[0]).charValue());
        }
    }
    ,
    ON_VERBATIM{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onVerbatim((String)eventParameters[0], (Boolean)eventParameters[1], (Map)eventParameters[2]);
        }
    }
    ,
    ON_WORD{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.onWord((String)eventParameters[0]);
        }
    }
    ,
    BEGIN_FIGURE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginFigure((Map)eventParameters[0]);
        }
    }
    ,
    BEGIN_FIGURE_CAPTION{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.beginFigureCaption((Map)eventParameters[0]);
        }
    }
    ,
    END_FIGURE{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endFigure((Map)eventParameters[0]);
        }
    }
    ,
    END_FIGURE_CAPTION{

        @Override
        public void fireEvent(Listener listener, Object ... eventParameters) {
            listener.endFigureCaption((Map)eventParameters[0]);
        }
    };


    public abstract void fireEvent(Listener var1, Object ... var2);

    public boolean isInlineEnd() {
        return false;
    }
}

