/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogUtils;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.OrBlockMatcher;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.util.ErrorBlockGenerator;

@Component
@Singleton
public class DefaultErrorBlockGenerator
implements ErrorBlockGenerator {
    @Inject
    protected Logger logger;

    @Override
    public List<Block> generateErrorBlocks(boolean inline, String messageId, String defaultMessage, String defaultDescription, Object ... arguments) {
        LogEvent message = LogUtils.newLogEvent((Marker)(messageId != null ? new TranslationMarker(messageId) : null), (LogLevel)LogLevel.ERROR, (String)(defaultMessage != null && !defaultMessage.endsWith(".") ? defaultMessage + "." : defaultMessage), (Object[])arguments);
        LogEvent description = defaultDescription != null ? LogUtils.newLogEvent((Marker)(messageId != null ? new TranslationMarker(messageId + ".description") : null), (LogLevel)LogLevel.ERROR, (String)defaultDescription, (Object[])arguments) : null;
        return this.generateErrorBlocks(inline, message, description);
    }

    protected List<Block> generateErrorBlocks(boolean inline, LogEvent message, LogEvent description) {
        ArrayList<Block> errorBlocks = new ArrayList<Block>();
        Map<String, String> errorBlockParams = Collections.singletonMap("class", "xwikirenderingerror");
        Map<String, String> errorDescriptionBlockParams = Collections.singletonMap("class", "xwikirenderingerrordescription hidden");
        StringBuilder messageBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)message.getMessage())) {
            messageBuilder.append(message.getFormattedMessage());
        }
        ArrayList<Block> descriptionChildren = new ArrayList<Block>();
        this.addDescriptionBlock(inline, description, descriptionChildren);
        this.addStackTraceBlock(inline, message, messageBuilder, descriptionChildren);
        if (!descriptionChildren.isEmpty()) {
            messageBuilder.append(" Click on this message for details.");
        }
        if (inline) {
            errorBlocks.add(new FormatBlock(Arrays.asList(new WordBlock(messageBuilder.toString())), Format.NONE, errorBlockParams));
            if (!descriptionChildren.isEmpty()) {
                errorBlocks.add(new FormatBlock(descriptionChildren, Format.NONE, errorDescriptionBlockParams));
            }
        } else {
            errorBlocks.add(new GroupBlock(Arrays.asList(new WordBlock(messageBuilder.toString())), errorBlockParams));
            if (!descriptionChildren.isEmpty()) {
                errorBlocks.add(new GroupBlock((List<Block>)descriptionChildren, errorDescriptionBlockParams));
            }
        }
        return errorBlocks;
    }

    private void addDescriptionBlock(boolean inline, LogEvent description, List<Block> descriptionChildren) {
        if (description != null) {
            descriptionChildren.add(new VerbatimBlock(description.getFormattedMessage(), inline));
        }
    }

    private void addStackTraceBlock(boolean inline, LogEvent message, StringBuilder messageBuilder, List<Block> descriptionChildren) {
        if (message.getThrowable() != null) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)message.getThrowable());
            if (rootCause == null) {
                rootCause = message.getThrowable();
            }
            descriptionChildren.add(new VerbatimBlock(ExceptionUtils.getStackTrace((Throwable)message.getThrowable()), inline));
            messageBuilder.append(" Cause: [");
            messageBuilder.append(rootCause.getMessage());
            messageBuilder.append("].");
        }
    }

    @Override
    public List<Block> generateErrorBlocks(String message, String description, boolean isInline) {
        return this.generateErrorBlocks(isInline, null, message, description, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public List<Block> generateErrorBlocks(String messagePrefix, Throwable throwable, boolean isInline) {
        return this.generateErrorBlocks(isInline, null, messagePrefix, null, throwable);
    }

    @Override
    public boolean containsError(Block parent) {
        boolean foundError = false;
        List groupAndFormatBlocks = parent.getBlocks(new OrBlockMatcher(new ClassBlockMatcher(GroupBlock.class), new ClassBlockMatcher(FormatBlock.class)), Block.Axes.DESCENDANT);
        for (Block block : groupAndFormatBlocks) {
            String classParameter = block.getParameters().get("class");
            if (classParameter == null || !classParameter.contains("xwikirenderingerror")) continue;
            foundError = true;
            break;
        }
        return foundError;
    }
}

